/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.data;

import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public record ProjectileData(float velocity, float accuracy, float antiGrav, float penetration, float damage) implements ModuleData<ProjectileData>
{
    private final float accuracy;
    private final float antiGrav;

    public float accuracy() {
        return this.accuracy > 1.0f ? 1.0f : this.accuracy;
    }

    public float antiGrav() {
        return this.antiGrav > 1.0f ? 1.0f : this.antiGrav;
    }

    @Override
    public ProjectileData combine(ProjectileData other) {
        return new ProjectileData(this.velocity + other.velocity, this.accuracy + other.accuracy, this.antiGrav + other.antiGrav, this.penetration + other.penetration, this.damage + other.damage);
    }

    @Override
    public void addInformation(Map<Component, Component> map, ModuleContext context, boolean stack) {
        if (this.velocity() != 0.0f) {
            int vel = Math.round(this.velocity() * 100.0f);
            map.put((Component)new TranslatableComponent("module.draconicevolution.proj_velocity.name"), (Component)new TranslatableComponent("module.draconicevolution.proj_velocity.value", new Object[]{vel > 0 ? "+" + vel : Integer.valueOf(vel), Math.round(60.0f * (this.velocity() + 1.0f))}));
        }
        if (this.accuracy() != 0.0f) {
            int acc = Math.round(this.accuracy() * -100.0f);
            map.put((Component)new TranslatableComponent("module.draconicevolution.proj_accuracy.name"), (Component)new TranslatableComponent("module.draconicevolution.proj_accuracy.value", new Object[]{acc > 0 ? "+" + acc : Integer.valueOf(acc)}));
        }
        if (this.antiGrav() != 0.0f) {
            int antiGrav = Math.round(this.antiGrav() * 100.0f);
            map.put((Component)new TranslatableComponent("module.draconicevolution.proj_grav_comp.name"), (Component)new TranslatableComponent("module.draconicevolution.proj_grav_comp.value", new Object[]{antiGrav > 0 ? "+" + antiGrav : Integer.valueOf(antiGrav)}));
        }
        if (this.penetration() > 0.0f && (this.penetration() > this.velocity() || !stack)) {
            int pen = Math.round(this.penetration() * 100.0f);
            map.put((Component)new TranslatableComponent("module.draconicevolution.proj_penetration.name"), (Component)new TranslatableComponent("module.draconicevolution.proj_penetration.value", new Object[]{pen > 0 ? "+" + pen : Integer.valueOf(pen)}));
            if (stack) {
                map.put((Component)new TranslatableComponent("module.draconicevolution.proj_penetration.info"), null);
                map.put((Component)new TranslatableComponent("module.draconicevolution.proj_penetration.info2"), null);
            }
        }
        if (this.damage() != 0.0f) {
            int damage = Math.round(this.damage() * 100.0f);
            map.put((Component)new TranslatableComponent("module.draconicevolution.proj_damage.name"), (Component)new TranslatableComponent("module.draconicevolution.proj_damage.value", new Object[]{damage > 0 ? "+" + damage : Integer.valueOf(damage)}));
        }
    }
}

