/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.crafting;

import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class IngredientStack
extends Ingredient {
    public static final Serializer SERIALIZER = new Serializer();
    public static final IngredientStack EMPTY = new IngredientStack(Stream.empty(), 0);
    private final int count;

    protected IngredientStack(Stream<? extends Ingredient.Value> itemLists, int count) {
        super(itemLists);
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        this.m_43948_();
        if (this.f_43903_.length == 0) {
            return stack.m_41619_();
        }
        for (ItemStack itemstack : this.f_43903_) {
            if (itemstack.m_41720_() != stack.m_41720_() || stack.m_41613_() < this.count) continue;
            return true;
        }
        return false;
    }

    public boolean itemTest(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        this.m_43948_();
        if (this.f_43903_.length == 0) {
            return stack.m_41619_();
        }
        for (ItemStack itemstack : this.f_43903_) {
            if (itemstack.m_41720_() != stack.m_41720_()) continue;
            return true;
        }
        return false;
    }

    public void m_43948_() {
        if (this.f_43903_ == null) {
            this.f_43903_ = (ItemStack[])Arrays.stream(this.f_43902_).flatMap(itemList -> itemList.m_6223_().stream()).peek(stack -> stack.m_41764_(this.count)).distinct().toArray(ItemStack[]::new);
        }
    }

    public IIngredientSerializer<? extends IngredientStack> getSerializer() {
        return SERIALIZER;
    }

    public JsonElement m_43942_() {
        JsonObject obj = new JsonObject();
        obj.addProperty("count", (Number)this.count);
        JsonArray jsonarray = new JsonArray();
        for (Ingredient.Value ingredient$iitemlist : this.f_43902_) {
            jsonarray.add((JsonElement)ingredient$iitemlist.m_6544_());
        }
        obj.add("items", (JsonElement)jsonarray);
        obj.addProperty("type", DraconicAPI.INGREDIENT_STACK_TYPE.toString());
        return obj;
    }

    public static IngredientStack fromItemListStream(Stream<? extends Ingredient.Value> stream, int count) {
        IngredientStack ingredient = new IngredientStack(stream, count);
        return ingredient.f_43902_.length == 0 ? EMPTY : ingredient;
    }

    public static IngredientStack fromItems(int count, ItemLike ... itemsIn) {
        return IngredientStack.fromStacks(Arrays.stream(itemsIn).map(ItemStack::new), count);
    }

    public static IngredientStack fromStacks(int count, ItemStack ... stacks) {
        return IngredientStack.fromStacks(Arrays.stream(stacks), count);
    }

    public static IngredientStack fromStacks(Stream<ItemStack> stacks, int count) {
        return IngredientStack.fromItemListStream(stacks.filter(stack -> !stack.m_41619_()).map(Ingredient.ItemValue::new), count);
    }

    public static IngredientStack fromTag(TagKey<Item> tagIn, int count) {
        return IngredientStack.fromItemListStream(Stream.of(new Ingredient.TagValue(tagIn)), count);
    }

    public static class Serializer
    implements IIngredientSerializer<IngredientStack> {
        public IngredientStack parse(FriendlyByteBuf buffer) {
            short count = buffer.readShort();
            return IngredientStack.fromItemListStream(Stream.generate(() -> new Ingredient.ItemValue(buffer.m_130267_())).limit(buffer.m_130242_()), count);
        }

        public IngredientStack parse(JsonObject json) {
            short count = json.get("count").getAsShort();
            JsonArray stacks = json.get("items").getAsJsonArray();
            return IngredientStack.fromItemListStream(Streams.stream((Iterable)stacks).map(e -> Ingredient.m_43919_((JsonObject)e.getAsJsonObject())), count);
        }

        public void write(FriendlyByteBuf buffer, IngredientStack ingredient) {
            buffer.writeShort(ingredient.getCount());
            ItemStack[] items = ingredient.m_43908_();
            buffer.m_130130_(items.length);
            for (ItemStack stack : items) {
                buffer.m_130055_(stack);
            }
        }
    }
}

