/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.crafting;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionDataTransfer;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FusionRecipe
implements IFusionRecipe {
    private ResourceLocation id;
    private final ItemStack result;
    private final Ingredient catalyst;
    private final long totalEnergy;
    private final TechLevel techLevel;
    private final Collection<FusionIngredient> ingredients;

    public FusionRecipe(ResourceLocation id, ItemStack result, Ingredient catalyst, long totalEnergy, TechLevel techLevel, Collection<FusionIngredient> ingredients) {
        this.id = id;
        this.result = result;
        this.catalyst = catalyst;
        this.totalEnergy = totalEnergy;
        this.techLevel = techLevel;
        this.ingredients = ingredients;
    }

    @Override
    public TechLevel getRecipeTier() {
        return this.techLevel;
    }

    @Override
    public long getEnergyCost() {
        return this.totalEnergy;
    }

    @Override
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients.stream().map(fusionIngredient -> fusionIngredient.ingredient).collect(Collectors.toCollection(NonNullList::m_122779_));
    }

    @Override
    public List<IFusionRecipe.IFusionIngredient> fusionIngredients() {
        return ImmutableList.copyOf(this.ingredients);
    }

    @Override
    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public ItemStack assemble(IFusionInventory inv) {
        ItemStack stack = this.result.m_41777_();
        if (stack.m_41720_() instanceof IFusionDataTransfer) {
            ((IFusionDataTransfer)stack.m_41720_()).transferIngredientData(stack, inv);
        }
        return stack;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return DraconicAPI.FUSION_RECIPE_SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<FusionRecipe> {
        public FusionRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            Ingredient catalyst = CraftingHelper.getIngredient((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"catalyst"));
            ArrayList<FusionIngredient> fusionIngredients = new ArrayList<FusionIngredient>();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (JsonElement element : ingredients) {
                Ingredient ingredient = element.isJsonObject() && element.getAsJsonObject().has("ingredient") ? CraftingHelper.getIngredient((JsonElement)element.getAsJsonObject().get("ingredient")) : CraftingHelper.getIngredient((JsonElement)element);
                boolean isConsumed = !element.isJsonObject() || GsonHelper.m_13855_((JsonObject)element.getAsJsonObject(), (String)"consume", (boolean)true);
                fusionIngredients.add(new FusionIngredient(ingredient, isConsumed));
            }
            long totalEnergy = GsonHelper.m_13921_((JsonObject)json, (String)"total_energy");
            TechLevel techLevel = TechLevel.valueOf((String)GsonHelper.m_13851_((JsonObject)json, (String)"tier", (String)TechLevel.DRACONIUM.name()));
            return new FusionRecipe(id, result, catalyst, totalEnergy, techLevel, fusionIngredients);
        }

        public FusionRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            ItemStack result = buffer.m_130267_();
            Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int count = buffer.readByte();
            ArrayList<FusionIngredient> fusionIngredients = new ArrayList<FusionIngredient>();
            for (int i = 0; i < count; ++i) {
                fusionIngredients.add(FusionIngredient.read(buffer));
            }
            long totalEnergy = buffer.readLong();
            TechLevel techLevel = TechLevel.VALUES[Mth.m_14045_((int)buffer.readByte(), (int)0, (int)(TechLevel.values().length - 1))];
            return new FusionRecipe(id, result, catalyst, totalEnergy, techLevel, fusionIngredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, FusionRecipe recipe) {
            buffer.writeItemStack(recipe.result, false);
            recipe.catalyst.m_43923_(buffer);
            buffer.writeByte(recipe.ingredients.size());
            for (FusionIngredient ingredient : recipe.ingredients) {
                ingredient.write(buffer);
            }
            buffer.writeLong(recipe.totalEnergy);
            buffer.writeByte(recipe.techLevel.index);
        }
    }

    public static class FusionIngredient
    implements IFusionRecipe.IFusionIngredient {
        private final Ingredient ingredient;
        private final boolean consume;

        public FusionIngredient(Ingredient ingredient, boolean consume) {
            this.ingredient = ingredient;
            this.consume = consume;
        }

        @Override
        public Ingredient get() {
            return this.ingredient;
        }

        @Override
        public boolean consume() {
            return this.consume;
        }

        protected void write(FriendlyByteBuf buffer) {
            buffer.writeBoolean(this.consume);
            this.ingredient.m_43923_(buffer);
        }

        protected static FusionIngredient read(FriendlyByteBuf buffer) {
            boolean consume = buffer.readBoolean();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new FusionIngredient(ingredient, consume);
        }
    }
}

