/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.silveroak.helper;

import cloud.lemonslice.silveroak.client.texture.TexturePos;
import cloud.lemonslice.silveroak.client.widget.IconButton;
import cloud.lemonslice.silveroak.helper.ColorHelper;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Transformation;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.gui.GuiUtils;
import net.minecraftforge.fluids.FluidStack;

public final class GuiHelper {
    public static void drawLayer(PoseStack poseStack, int x, int y, TexturePos pos, int z) {
        GuiUtils.drawTexturedModalRect((PoseStack)poseStack, (int)x, (int)y, (int)pos.getX(), (int)pos.getY(), (int)pos.getWidth(), (int)pos.getHeight(), (float)z);
    }

    public static void drawLayer(PoseStack poseStack, int x, int y, TexturePos pos) {
        GuiUtils.drawTexturedModalRect((PoseStack)poseStack, (int)x, (int)y, (int)pos.getX(), (int)pos.getY(), (int)pos.getWidth(), (int)pos.getHeight(), (float)0.0f);
    }

    public static void drawLayer(Screen gui, PoseStack poseStack, int x, int y, TexturePos pos) {
        gui.m_93228_(poseStack, x, y, pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight());
    }

    public static void drawLayerBySize(PoseStack poseStack, int x, int y, TexturePos pos, int textureWidth, int textureHeight) {
        GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)pos.getWidth(), (int)pos.getHeight(), (float)pos.getX(), (float)pos.getY(), (int)pos.getWidth(), (int)pos.getHeight(), (int)textureWidth, (int)textureHeight);
    }

    public static void drawLayerBySize(PoseStack poseStack, int x, int y, TexturePos pos) {
        GuiHelper.drawLayerBySize(poseStack, x, y, pos, pos.getWidth(), pos.getHeight());
    }

    public static void renderIconButton(PoseStack poseStack, float partialTicks, int mouseX, int mouseY, int z, ResourceLocation texture, IconButton button, TexturePos normalPos, TexturePos hoveredPos, TexturePos pressedPos) {
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        if (button.isPressed()) {
            GuiHelper.drawLayer(poseStack, button.f_93620_, button.f_93621_, pressedPos);
            RenderSystem.m_69461_();
            return;
        }
        if (button.m_198029_()) {
            GuiHelper.drawLayer(poseStack, button.f_93620_, button.f_93621_, hoveredPos);
            RenderSystem.m_69461_();
            return;
        }
        GuiHelper.drawLayer(poseStack, button.f_93620_, button.f_93621_, normalPos);
        RenderSystem.m_69461_();
        button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public static void renderButton(PoseStack poseStack, float partialTicks, int mouseX, int mouseY, int z, ResourceLocation texture, Button button, TexturePos normalPos, TexturePos hoveredPos) {
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        if (button.m_198029_()) {
            GuiHelper.drawLayer(poseStack, button.f_93620_, button.f_93621_, hoveredPos);
        } else {
            GuiHelper.drawLayer(poseStack, button.f_93620_, button.f_93621_, normalPos);
        }
        RenderSystem.m_69461_();
        button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public static void drawTank(Screen gui, TexturePos pos, FluidStack fluid, int fluidHeight) {
        int width = pos.getWidth();
        if (fluid.isEmpty()) {
            return;
        }
        if (fluidHeight != 0) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)gui.getMinecraft().m_91258_(InventoryMenu.f_39692_).apply(fluid.getFluid().getAttributes().getStillTexture());
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            int color = fluid.getFluid().getAttributes().getColor(fluid);
            RenderSystem.m_157429_((float)ColorHelper.getRedF(color), (float)ColorHelper.getGreenF(color), (float)ColorHelper.getBlueF(color), (float)ColorHelper.getAlphaF(color));
            for (int j = 0; j < width / 16; ++j) {
                int count = 0;
                int fluidH = fluidHeight;
                while (fluidH > 16) {
                    GuiHelper.drawSmallFluidSprite(pos.getX() + j * 16, pos.getY() + pos.getHeight() - (count + 1) * 16, 0, 0, 0, 16, 16, sprite);
                    fluidH -= 16;
                    ++count;
                }
                GuiHelper.drawSmallFluidSprite(pos.getX() + j * 16, pos.getY() + pos.getHeight() - count * 16 - fluidH, 0, 0, 16 - fluidH, 16, fluidH, sprite);
            }
            int fluidWidth = width % 16;
            int j = width / 16;
            if (fluidWidth != 0) {
                int count = 0;
                int fluidH = fluidHeight;
                while (fluidH > 16) {
                    GuiHelper.drawSmallFluidSprite(pos.getX() + j * 16, pos.getY() + pos.getHeight() - (count + 1) * 16, 0, 0, 0, fluidWidth, 16, sprite);
                    fluidH -= 16;
                    ++count;
                }
                GuiHelper.drawSmallFluidSprite(pos.getX() + j * 16, pos.getY() + pos.getHeight() - count * 16 - fluidH, 0, 0, 16 - fluidH, fluidWidth, fluidH, sprite);
            }
        }
    }

    public static void drawTransparentStringDefault(Font font, String text, float x, float y, int color, boolean shadow) {
        GuiHelper.drawSpecialString(font, text, x, y, color, shadow, true, 0, 0xF000F0);
    }

    public static void drawSpecialString(Font font, String text, float x, float y, int color, boolean shadow, boolean transparent, int colorBackground, int packedLight) {
        MultiBufferSource.BufferSource iRenderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_92811_(text, x, y, color, shadow, Transformation.m_121093_().m_121104_(), (MultiBufferSource)iRenderTypeBuffer, transparent, colorBackground, packedLight);
        iRenderTypeBuffer.m_109911_();
    }

    public static void drawTooltip(Screen gui, PoseStack matrix, int mouseX, int mouseY, int x, int y, int weight, int height, List<Component> list) {
        if (x <= mouseX && mouseX <= x + weight && y <= mouseY && mouseY <= y + height) {
            gui.m_169388_(matrix, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void drawFluidTooltip(Screen gui, PoseStack matrix, int mouseX, int mouseY, int x, int y, int width, int height, Component name, int amount) {
        if (amount != 0) {
            ArrayList list = Lists.newArrayList((Object[])new Component[]{name});
            DecimalFormat df = new DecimalFormat("#,###");
            list.add(new TextComponent(df.format(amount) + " mB").m_130940_(ChatFormatting.GRAY));
            GuiHelper.drawTooltip(gui, matrix, mouseX, mouseY, x, y, width, height, list);
        }
    }

    public static void drawSmallFluidSprite(int x0, int y0, int z, int u0, int v0, int width, int height, TextureAtlasSprite sprite) {
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        GuiHelper.innerBlit(x0, x0 + width, y0, y0 + height, z, GuiHelper.getCorrespondingUV(minU, maxU, u0), GuiHelper.getCorrespondingUV(minU, maxU, width), GuiHelper.getCorrespondingUV(minV, maxV, v0), GuiHelper.getCorrespondingUV(minV, maxV, height));
    }

    private static float getCorrespondingUV(float min, float max, int uv) {
        return min + (max - min) * (float)uv / 16.0f;
    }

    static void innerBlit(int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        RenderSystem.m_69478_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x0, (double)y1, (double)z).m_7421_(u0, v1).m_5752_();
        buffer.m_5483_((double)x1, (double)y1, (double)z).m_7421_(u1, v1).m_5752_();
        buffer.m_5483_((double)x1, (double)y0, (double)z).m_7421_(u1, v0).m_5752_();
        buffer.m_5483_((double)x0, (double)y0, (double)z).m_7421_(u0, v0).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
    }
}

