/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.silveroak.common.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidIngredient
implements Predicate<FluidStack> {
    private static final Set<FluidIngredient> INSTANCES = Collections.newSetFromMap(new WeakHashMap());
    private static final Predicate<? super IFluidList> IS_EMPTY = fluidList -> !fluidList.getStacks().stream().allMatch(FluidStack::isEmpty);
    public static final FluidIngredient EMPTY = new FluidIngredient(Stream.empty());
    private final IFluidList[] acceptedFluids;
    private FluidStack[] matchingStacks;
    private IntList matchingStacksPacked;

    public static void invalidateAll() {
        INSTANCES.stream().filter(Objects::nonNull).forEach(FluidIngredient::invalidate);
    }

    protected FluidIngredient(Stream<? extends IFluidList> fluidLists) {
        this.acceptedFluids = (IFluidList[])fluidLists.filter(IS_EMPTY).toArray(IFluidList[]::new);
        INSTANCES.add(this);
    }

    public FluidStack[] getMatchingStacks() {
        this.determineMatchingStacks();
        return this.matchingStacks;
    }

    private void determineMatchingStacks() {
        if (this.matchingStacks == null) {
            this.matchingStacks = (FluidStack[])Arrays.stream(this.acceptedFluids).flatMap(fluidList -> fluidList.getStacks().stream()).distinct().toArray(FluidStack[]::new);
        }
    }

    @Override
    public boolean test(@Nullable FluidStack fluidStackIn) {
        if (fluidStackIn == null) {
            return false;
        }
        if (this.acceptedFluids.length == 0) {
            return fluidStackIn.isEmpty();
        }
        this.determineMatchingStacks();
        for (FluidStack fluidStack : this.matchingStacks) {
            if (fluidStack.getFluid() != fluidStackIn.getFluid() || fluidStackIn.getAmount() < fluidStack.getAmount()) continue;
            return true;
        }
        return false;
    }

    public IntList getValidFluidStacksPacked() {
        if (this.matchingStacksPacked == null) {
            this.determineMatchingStacks();
            this.matchingStacksPacked = new IntArrayList(this.matchingStacks.length);
            for (FluidStack fluidStack : this.matchingStacks) {
                this.matchingStacksPacked.add(Registry.f_122822_.m_7447_((Object)fluidStack.getFluid()));
            }
            this.matchingStacksPacked.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.matchingStacksPacked;
    }

    public final void write(FriendlyByteBuf buffer) {
        this.determineMatchingStacks();
        buffer.m_130130_(this.matchingStacks.length);
        for (FluidStack matchingStack : this.matchingStacks) {
            buffer.writeFluidStack(matchingStack);
        }
    }

    public JsonElement serialize() {
        if (this.acceptedFluids.length == 1) {
            return this.acceptedFluids[0].serialize();
        }
        JsonArray jsonarray = new JsonArray();
        for (IFluidList ingredient$ifluidlist : this.acceptedFluids) {
            jsonarray.add((JsonElement)ingredient$ifluidlist.serialize());
        }
        return jsonarray;
    }

    public boolean hasNoMatchingFluids() {
        return !(this.acceptedFluids.length != 0 || this.matchingStacks != null && this.matchingStacks.length != 0 || this.matchingStacksPacked != null && !this.matchingStacksPacked.isEmpty());
    }

    protected void invalidate() {
        this.matchingStacks = null;
        this.matchingStacksPacked = null;
    }

    public static FluidIngredient fromFluidListStream(Stream<? extends IFluidList> stream) {
        FluidIngredient ingredient = new FluidIngredient(stream);
        return ingredient.acceptedFluids.length == 0 ? EMPTY : ingredient;
    }

    public static FluidIngredient fromFluid(int amount, Fluid ... fluids) {
        return FluidIngredient.fromFluidListStream(Arrays.stream(fluids).map(fluid -> new SingleFluidList(new FluidStack(fluid, amount))));
    }

    public static FluidIngredient fromStacks(FluidStack ... stacks) {
        return FluidIngredient.fromFluidListStream(Arrays.stream(stacks).map(SingleFluidList::new));
    }

    public static FluidIngredient fromTag(int amount, TagKey<Fluid> tagIn) {
        return FluidIngredient.fromFluidListStream(Stream.of(new TagList(tagIn, amount)));
    }

    public static FluidIngredient read(FriendlyByteBuf buffer) {
        int i = buffer.m_130242_();
        return FluidIngredient.fromFluidListStream(Stream.generate(() -> new SingleFluidList(buffer.readFluidStack())).limit(i));
    }

    public static FluidIngredient deserialize(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return FluidIngredient.fromFluidListStream(Stream.of(FluidIngredient.deserializeFluidList(json.getAsJsonObject())));
            }
            if (json.isJsonArray()) {
                JsonArray jsonarray = json.getAsJsonArray();
                if (jsonarray.size() == 0) {
                    throw new JsonSyntaxException("Fluid array cannot be empty, at least one fluid must be defined");
                }
                return FluidIngredient.fromFluidListStream(StreamSupport.stream(jsonarray.spliterator(), false).map(jsonElement -> FluidIngredient.deserializeFluidList(GsonHelper.m_13918_((JsonElement)jsonElement, (String)"fluid"))));
            }
            throw new JsonSyntaxException("Expected fluid to be object or array of objects");
        }
        throw new JsonSyntaxException("Fluid cannot be null");
    }

    public static IFluidList deserializeFluidList(JsonObject json) {
        if (json.has("fluid") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an fluid, not both");
        }
        if (json.has("fluid")) {
            int amount = GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)1000);
            ResourceLocation resourcelocation1 = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourcelocation1);
            if (fluid == null) {
                throw new JsonSyntaxException("Unknown fluid '" + resourcelocation1 + "'");
            }
            return new SingleFluidList(new FluidStack(fluid, amount));
        }
        if (json.has("tag")) {
            int amount = GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)1000);
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            TagKey tag = FluidTags.create((ResourceLocation)resourcelocation);
            return new TagList((TagKey<Fluid>)tag, amount);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an fluid");
    }

    public static FluidIngredient merge(Collection<FluidIngredient> parts) {
        return FluidIngredient.fromFluidListStream(parts.stream().flatMap(i -> Arrays.stream(i.acceptedFluids)));
    }

    public static interface IFluidList {
        public Collection<FluidStack> getStacks();

        public JsonObject serialize();
    }

    public static class TagList
    implements IFluidList {
        private final TagKey<Fluid> tag;
        private final int amount;

        public TagList(TagKey<Fluid> tagIn, int amount) {
            this.tag = tagIn;
            this.amount = amount;
        }

        @Override
        public Collection<FluidStack> getStacks() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : Registry.f_122822_.m_206058_(this.tag)) {
                list.add(new FluidStack((Fluid)holder.m_203334_(), this.amount));
            }
            return list;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", this.tag.f_203868_().toString());
            jsonobject.addProperty("amount", (Number)this.amount);
            return jsonobject;
        }
    }

    public static class SingleFluidList
    implements IFluidList {
        private final FluidStack stack;

        public SingleFluidList(FluidStack stackIn) {
            this.stack = stackIn;
        }

        @Override
        public Collection<FluidStack> getStacks() {
            return Collections.singleton(this.stack);
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.stack.getFluid()).toString());
            jsonobject.addProperty("amount", (Number)this.stack.getAmount());
            return jsonobject;
        }
    }
}

