/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.silveroak.common.environment;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.biome.Biome;

public enum Temperature {
    FREEZING(ChatFormatting.BLUE, Float.NEGATIVE_INFINITY, 0.15f),
    COLD(ChatFormatting.AQUA, 0.15f, 0.4f),
    COOL(ChatFormatting.GREEN, 0.4f, 0.65f),
    WARM(ChatFormatting.YELLOW, 0.65f, 0.9f),
    HOT(ChatFormatting.GOLD, 0.9f, 1.25f),
    HEAT(ChatFormatting.RED, 1.25f, Float.POSITIVE_INFINITY);

    private final ChatFormatting color;
    private final float min;
    private final float max;

    private Temperature(ChatFormatting color, float min, float max) {
        this.color = color;
        this.min = min;
        this.max = max;
    }

    public int getId() {
        return this.ordinal() + 1;
    }

    public String getName() {
        return this.toString().toLowerCase();
    }

    public boolean isInTemperature(float temp) {
        return this.min < temp && temp <= this.max;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getWidth() {
        return this.max - this.min;
    }

    public Component getTranslation() {
        return new TranslatableComponent("info.silveroak.environment.temperature." + this.getName()).m_130940_(this.color);
    }

    public static Temperature getTemperatureLevel(Biome biome, BlockPos pos) {
        return Temperature.getTemperatureLevel(biome.m_47505_(pos));
    }

    public static Temperature getTemperatureLevel(float temp) {
        for (Temperature t : Temperature.values()) {
            if (!t.isInTemperature(temp)) continue;
            return t;
        }
        return FREEZING;
    }
}

