/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.silveroak.common.environment;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.biome.Biome;

public enum Rainfall {
    RARE(ChatFormatting.RED, Float.NEGATIVE_INFINITY, 0.1f),
    SCARCE(ChatFormatting.GOLD, 0.1f, 0.3f),
    MODERATE(ChatFormatting.WHITE, 0.3f, 0.6f),
    ADEQUATE(ChatFormatting.DARK_AQUA, 0.6f, 0.8f),
    ABUNDANT(ChatFormatting.DARK_GREEN, 0.8f, Float.POSITIVE_INFINITY);

    private final float min;
    private final float max;
    private final ChatFormatting color;

    private Rainfall(ChatFormatting color, float min, float max) {
        this.color = color;
        this.min = min;
        this.max = max;
    }

    public int getId() {
        return this.ordinal() + 1;
    }

    public String getName() {
        return this.toString().toLowerCase();
    }

    public boolean isInRainfall(float rainfall) {
        return this.min < rainfall && rainfall <= this.max;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public Component getTranslation() {
        return new TranslatableComponent("info.silveroak.environment.rainfall." + this.getName()).m_130940_(this.color);
    }

    public static Rainfall getRainfallLevel(Biome biome) {
        return Rainfall.getRainfallLevel(biome.m_47548_());
    }

    public static Rainfall getRainfallLevel(float rainfall) {
        for (Rainfall r : Rainfall.values()) {
            if (!r.isInRainfall(rainfall)) continue;
            return r;
        }
        return RARE;
    }
}

