/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.silveroak.client.widget;

import cloud.lemonslice.silveroak.client.widget.EditableTextBox;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class ReadOnlyTextBox
extends AbstractWidget {
    private final Minecraft mc = Minecraft.m_91087_();
    private final Font font;
    private final int color;
    private final int spacing;
    private final EditableTextBox.Page currentPage;
    private String page = "";

    public ReadOnlyTextBox(ItemStack item, int x, int y, int boxWidth, int boxHeight, int spacingPixel, int color, Component title) {
        super(x, y, boxWidth, boxHeight, title);
        Tag nbt;
        this.font = this.mc.f_91062_;
        this.color = color;
        this.spacing = spacingPixel;
        CompoundTag compoundTag = item.m_41783_();
        if (compoundTag != null && (nbt = compoundTag.m_128423_("Text")) != null) {
            this.page = nbt.m_6426_().m_7916_();
        }
        this.currentPage = this.createPage();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    private EditableTextBox.Page createPage() {
        if (this.page.isEmpty()) {
            return EditableTextBox.Page.EMPTY;
        }
        IntArrayList intlist = new IntArrayList();
        ArrayList lines = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        StringSplitter stringSplitter = this.font.m_92865_();
        stringSplitter.m_92364_(this.page, this.f_93618_, Style.f_131099_, true, (arg_0, arg_1, arg_2) -> this.lambda$createPage$0(mutableint, mutableboolean, (IntList)intlist, lines, arg_0, arg_1, arg_2));
        int[] linesStartPos = intlist.toIntArray();
        return new EditableTextBox.Page(this.page, new EditableTextBox.Point(0, 0), true, linesStartPos, lines.toArray(new EditableTextBox.Line[0]), new Rect2i[0]);
    }

    private EditableTextBox.Point getPointPosInScreen(EditableTextBox.Point pointIn) {
        return new EditableTextBox.Point(pointIn.x + this.f_93620_, pointIn.y + this.f_93621_);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (EditableTextBox.Line line : this.currentPage.lines) {
            this.font.m_92889_(poseStack, line.lineTextComponent, (float)line.x, (float)line.y, this.color);
        }
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    private /* synthetic */ void lambda$createPage$0(MutableInt mutableint, MutableBoolean mutableboolean, IntList intlist, List lines, Style style, int lineStartPos, int lineEndPos) {
        int lineCount = mutableint.getAndIncrement();
        String lineTextRaw = this.page.substring(lineStartPos, lineEndPos);
        mutableboolean.setValue(lineTextRaw.endsWith("\n"));
        String lineText = StringUtils.stripEnd((String)lineTextRaw, (String)" \n");
        int y = lineCount * this.spacing;
        EditableTextBox.Point point = this.getPointPosInScreen(new EditableTextBox.Point(0, y));
        intlist.add(lineStartPos);
        lines.add(new EditableTextBox.Line(style, lineText, point.x, point.y));
    }
}

