/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.silveroak.client.widget;

import cloud.lemonslice.silveroak.network.SimpleNetworkHandler;
import cloud.lemonslice.silveroak.network.TextBoxEditMessage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class EditableTextBox
extends AbstractWidget {
    private final Minecraft mc = Minecraft.m_91087_();
    private final Font font;
    private boolean isModified = false;
    private int updateCount = 0;
    private long lastClickTime = 0L;
    private final int color;
    private final int spacing;
    private final TextFieldHelper textInputUtil;
    @Nullable
    private Page currentPage = null;
    private String page = "";
    private final ItemStack item;
    private final Player editingPlayer;
    private final InteractionHand hand;

    public EditableTextBox(ItemStack item, Player playerIn, InteractionHand handIn, int x, int y, int boxWidth, int boxHeight, int spacingPixel, int color, Component title) {
        super(x, y, boxWidth, boxHeight, title);
        Tag nbt;
        this.font = this.mc.f_91062_;
        this.color = color;
        this.spacing = spacingPixel;
        this.item = item;
        this.editingPlayer = playerIn;
        this.hand = handIn;
        CompoundTag compoundnbt = item.m_41783_();
        if (compoundnbt != null && (nbt = compoundnbt.m_128423_("Text")) != null) {
            this.page = nbt.m_6426_().m_7916_();
        }
        this.textInputUtil = new TextFieldHelper(() -> this.page, this::setText, this::getClipboardText, this::setClipboardText, text -> {
            if (text.length() >= 1024) return false;
            int n = this.font.m_92920_(text, boxWidth);
            Objects.requireNonNull(this.font);
            if (n > boxHeight * 9 / spacingPixel) return false;
            return true;
        });
    }

    public void init() {
        this.mc.f_91068_.m_90926_(true);
    }

    public void onClose() {
        this.mc.f_91068_.m_90926_(false);
    }

    public void tick() {
        ++this.updateCount;
    }

    public void sendTextToServer() {
        if (this.isModified) {
            this.item.m_41700_("Text", (Tag)StringTag.m_129297_((String)this.page));
            int i = this.hand == InteractionHand.MAIN_HAND ? this.editingPlayer.m_150109_().f_35977_ : 40;
            SimpleNetworkHandler.CHANNEL.sendToServer((Object)new TextBoxEditMessage(this.item, i));
        }
    }

    private Page createPage() {
        Point point;
        boolean flag;
        if (this.page.isEmpty()) {
            return Page.EMPTY;
        }
        int selectionEnd = this.textInputUtil.m_95194_();
        int selectionStart = this.textInputUtil.m_95197_();
        IntArrayList intlist = new IntArrayList();
        ArrayList lines = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        StringSplitter stringSplitter = this.font.m_92865_();
        stringSplitter.m_92364_(this.page, this.f_93618_, Style.f_131099_, true, (arg_0, arg_1, arg_2) -> this.lambda$createPage$2(mutableint, mutableboolean, (IntList)intlist, lines, arg_0, arg_1, arg_2));
        int[] linesStartPos = intlist.toIntArray();
        boolean bl = flag = selectionEnd == this.page.length();
        if (flag && mutableboolean.isTrue()) {
            point = new Point(0, lines.size() * this.spacing);
        } else {
            int line = EditableTextBox.getCursorLine(linesStartPos, selectionEnd);
            point = new Point(this.font.m_92895_(this.page.substring(linesStartPos[line], selectionEnd)), line * this.spacing);
        }
        ArrayList rectangleList = Lists.newArrayList();
        if (selectionEnd != selectionStart) {
            int selectionEndLine;
            int selectionMin = Math.min(selectionEnd, selectionStart);
            int selectionMax = Math.max(selectionEnd, selectionStart);
            int selectionStartLine = EditableTextBox.getCursorLine(linesStartPos, selectionMin);
            if (selectionStartLine == (selectionEndLine = EditableTextBox.getCursorLine(linesStartPos, selectionMax))) {
                int linePosY = selectionStartLine * this.spacing;
                int linePosX = linesStartPos[selectionStartLine];
                rectangleList.add(this.getRectangle(this.page, stringSplitter, selectionMin, selectionMax, linePosY, linePosX));
            } else {
                int i3 = selectionStartLine + 1 > linesStartPos.length ? this.page.length() : linesStartPos[selectionStartLine + 1];
                rectangleList.add(this.getRectangle(this.page, stringSplitter, selectionMin, i3, selectionStartLine * this.spacing, linesStartPos[selectionStartLine]));
                for (int j3 = selectionStartLine + 1; j3 < selectionEndLine; ++j3) {
                    int j2 = j3 * this.spacing;
                    String s1 = this.page.substring(linesStartPos[j3], linesStartPos[j3 + 1]);
                    int k2 = (int)stringSplitter.m_92353_(s1);
                    rectangleList.add(this.getRectangle(new Point(0, j2), new Point(k2, j2 + 9)));
                }
                rectangleList.add(this.getRectangle(this.page, stringSplitter, linesStartPos[selectionEndLine], selectionMax, selectionEndLine * this.spacing, linesStartPos[selectionEndLine]));
            }
        }
        return new Page(this.page, point, flag, linesStartPos, lines.toArray(new Line[0]), rectangleList.toArray(new Rect2i[0]));
    }

    private Rect2i getRectangle(String text, StringSplitter characterManager, int from, int to, int lineStart, int lineEnd) {
        String s = text.substring(lineEnd, from);
        String s1 = text.substring(lineEnd, to);
        Point pointFrom = new Point((int)characterManager.m_92353_(s), lineStart);
        Point pointTo = new Point((int)characterManager.m_92353_(s1), lineStart + this.spacing);
        return this.getRectangle(pointFrom, pointTo);
    }

    private Rect2i getRectangle(Point pointFromIn, Point pointToIn) {
        Point pointFrom = this.getPointPosInScreen(pointFromIn);
        Point pointTo = this.getPointPosInScreen(pointToIn);
        int i = Math.min(pointFrom.x, pointTo.x);
        int j = Math.max(pointFrom.x, pointTo.x);
        int k = Math.min(pointFrom.y, pointTo.y);
        int l = Math.max(pointFrom.y, pointTo.y);
        return new Rect2i(i, k, j - i, l - k);
    }

    private Page getPage() {
        if (this.currentPage == null) {
            this.currentPage = this.createPage();
        }
        return this.currentPage;
    }

    private void setText(String text) {
        this.page = text;
        this.isModified = true;
    }

    private String getClipboardText() {
        return TextFieldHelper.m_95169_((Minecraft)this.mc);
    }

    private void setClipboardText(String text) {
        TextFieldHelper.m_95155_((Minecraft)this.mc, (String)text);
    }

    public void shouldRefresh() {
        this.currentPage = null;
    }

    private void getDownLine() {
        this.toMoveCursorLine(1);
    }

    private void getUpLine() {
        this.toMoveCursorLine(-1);
    }

    private void toMoveCursorLine(int lineAdded) {
        int i = this.textInputUtil.m_95194_();
        int j = this.getPage().getLineToMove(i, lineAdded);
        this.textInputUtil.m_95179_(j, Screen.m_96638_());
    }

    private static int getCursorLine(int[] linesLength, int cursorPos) {
        int i = Arrays.binarySearch(linesLength, cursorPos);
        return i < 0 ? -(i + 2) : i;
    }

    private void moveToLineHead() {
        int i = this.textInputUtil.m_95194_();
        int j = this.getPage().getLineStartPos(i);
        this.textInputUtil.m_95179_(j, Screen.m_96638_());
    }

    private void moveToLineEnd() {
        int i = this.textInputUtil.m_95194_();
        int j = this.getPage().getLineEndPos(i);
        this.textInputUtil.m_95179_(j, Screen.m_96638_());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        boolean flag = this.keyPressedInBook(keyCode, scanCode, modifiers);
        if (flag) {
            this.shouldRefresh();
            return true;
        }
        return false;
    }

    private boolean keyPressedInBook(int keyCode, int scanCode, int modifiers) {
        if (Screen.m_96634_((int)keyCode)) {
            this.textInputUtil.m_95188_();
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            this.textInputUtil.m_95178_();
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            this.textInputUtil.m_95165_();
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            this.textInputUtil.m_95142_();
            return true;
        }
        switch (keyCode) {
            case 257: 
            case 335: {
                this.textInputUtil.m_95158_("\n");
                return true;
            }
            case 259: {
                this.textInputUtil.m_95189_(-1);
                return true;
            }
            case 261: {
                this.textInputUtil.m_95189_(1);
                return true;
            }
            case 262: {
                this.textInputUtil.m_95150_(1, Screen.m_96638_());
                return true;
            }
            case 263: {
                this.textInputUtil.m_95150_(-1, Screen.m_96638_());
                return true;
            }
            case 264: {
                this.getDownLine();
                return true;
            }
            case 265: {
                this.getUpLine();
                return true;
            }
            case 268: {
                this.moveToLineHead();
                return true;
            }
            case 269: {
                this.moveToLineEnd();
                return true;
            }
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (super.m_5534_(codePoint, modifiers)) {
            return true;
        }
        if (SharedConstants.m_136188_((char)codePoint)) {
            this.textInputUtil.m_95158_(Character.toString(codePoint));
            this.shouldRefresh();
            return true;
        }
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Page page = this.getPage();
        for (Line line : page.lines) {
            this.font.m_92889_(poseStack, line.lineTextComponent, (float)line.x, (float)line.y, this.color);
        }
        this.renderSelection(page.selection);
        this.renderCursor(poseStack, page.point, page.isInsert);
    }

    private void renderSelection(Rect2i[] selection) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (Rect2i rectangle2d : selection) {
            int i = rectangle2d.m_110085_();
            int j = rectangle2d.m_110086_();
            int k = i + rectangle2d.m_110090_();
            int l = j + rectangle2d.m_110091_();
            bufferbuilder.m_5483_((double)i, (double)l, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)k, (double)l, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)k, (double)j, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)i, (double)j, 0.0).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }

    private void renderCursor(PoseStack poseStack, Point point, boolean isInsert) {
        if (this.updateCount / 6 % 2 == 0 && this.f_93619_ != 0) {
            point = this.getPointPosInScreen(point);
            if (!isInsert) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)point.x, (int)(point.y - 1), (int)(point.x + 1), (int)(point.y + 9), (int)this.color);
            } else {
                this.font.m_92883_(poseStack, "_", (float)point.x, (float)point.y, this.color);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            long i = Util.m_137550_();
            int j = this.getPage().getMousePointPosInText(this.font, this.getPointPosInBox(new Point((int)mouseX, (int)mouseY)), this.spacing);
            if (j >= 0) {
                if (i - this.lastClickTime < 250L) {
                    if (!this.textInputUtil.m_95198_()) {
                        this.setSelection(j);
                    } else {
                        this.textInputUtil.m_95188_();
                    }
                } else {
                    this.textInputUtil.m_95179_(j, Screen.m_96638_());
                }
                this.shouldRefresh();
            }
            this.lastClickTime = i;
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            int i = this.getPage().getMousePointPosInText(this.font, this.getPointPosInBox(new Point((int)mouseX, (int)mouseY)), this.spacing);
            this.textInputUtil.m_95179_(i, true);
            this.shouldRefresh();
        }
        return true;
    }

    private void setSelection(int cursorPos) {
        this.textInputUtil.m_95147_(StringSplitter.m_92355_((String)this.page, (int)-1, (int)cursorPos, (boolean)false), StringSplitter.m_92355_((String)this.page, (int)1, (int)cursorPos, (boolean)false));
    }

    private Point getPointPosInBox(Point pointIn) {
        return new Point(pointIn.x - this.f_93620_, pointIn.y - this.f_93621_);
    }

    private Point getPointPosInScreen(Point pointIn) {
        return new Point(pointIn.x + this.f_93620_, pointIn.y + this.f_93621_);
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    private /* synthetic */ void lambda$createPage$2(MutableInt mutableint, MutableBoolean mutableboolean, IntList intlist, List lines, Style style, int lineStartPos, int lineEndPos) {
        int lineCount = mutableint.getAndIncrement();
        String lineTextRaw = this.page.substring(lineStartPos, lineEndPos);
        mutableboolean.setValue(lineTextRaw.endsWith("\n"));
        String lineText = StringUtils.stripEnd((String)lineTextRaw, (String)" \n");
        int y = lineCount * this.spacing;
        Point point = this.getPointPosInScreen(new Point(0, y));
        intlist.add(lineStartPos);
        lines.add(new Line(style, lineText, point.x, point.y));
    }

    static class Page {
        protected static final Page EMPTY = new Page("", new Point(0, 0), true, new int[]{0}, new Line[]{new Line(Style.f_131099_, "", 0, 0)}, new Rect2i[0]);
        private final String text;
        private final Point point;
        private final boolean isInsert;
        private final int[] linesStartPos;
        protected final Line[] lines;
        private final Rect2i[] selection;

        public Page(String text, Point point, boolean isInsert, int[] linesStartPos, Line[] lines, Rect2i[] selection) {
            this.text = text;
            this.point = point;
            this.isInsert = isInsert;
            this.linesStartPos = linesStartPos;
            this.lines = lines;
            this.selection = selection;
        }

        public int getMousePointPosInText(Font font, Point point, int spacingPixel) {
            int linePos = point.y / spacingPixel;
            if (linePos < 0) {
                return 0;
            }
            if (linePos >= this.lines.length) {
                return this.text.length();
            }
            Line line = this.lines[linePos];
            return this.linesStartPos[linePos] + font.m_92865_().m_92360_(line.lineText, point.x, line.style);
        }

        public int getLineToMove(int cursorPos, int lineAdded) {
            int k;
            int i = EditableTextBox.getCursorLine(this.linesStartPos, cursorPos);
            int j = i + lineAdded;
            if (0 <= j && j < this.linesStartPos.length) {
                int l = cursorPos - this.linesStartPos[i];
                int i1 = this.lines[j].lineText.length();
                k = this.linesStartPos[j] + Math.min(l, i1);
            } else {
                k = cursorPos;
            }
            return k;
        }

        public int getLineStartPos(int cursorPos) {
            int i = EditableTextBox.getCursorLine(this.linesStartPos, cursorPos);
            return this.linesStartPos[i];
        }

        public int getLineEndPos(int cursorPos) {
            int i = EditableTextBox.getCursorLine(this.linesStartPos, cursorPos);
            return this.linesStartPos[i] + this.lines[i].lineText.length();
        }
    }

    static class Point {
        public final int x;
        public final int y;

        Point(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    static class Line {
        private final Style style;
        private final String lineText;
        protected final Component lineTextComponent;
        protected final int x;
        protected final int y;

        public Line(Style style, String text, int x, int y) {
            this.style = style;
            this.lineText = text;
            this.x = x;
            this.y = y;
            this.lineTextComponent = new TextComponent(text).m_6270_(style);
        }
    }
}

