/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.silveroak.client.gui.hud;

import cloud.lemonslice.silveroak.client.texture.TexturePos;
import cloud.lemonslice.silveroak.common.environment.Temperature;
import cloud.lemonslice.silveroak.helper.GuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="silveroakoutpost")
public class ThermometerBarRenderer
extends GuiComponent {
    private static final ResourceLocation OVERLAY_BAR = new ResourceLocation("silveroakoutpost", "textures/gui/hud/env.png");
    private static final int WIDTH = 31;
    private static final int HEIGHT = 5;
    private static float temp = 0.0f;
    private static float level = 0.0f;

    public void renderStatusBar(PoseStack poseStack, int screenWidth, int screenHeight, float temp) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAY_BAR);
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        level = temp;
        int offsetX = (screenWidth - 31 + 1) / 2;
        int offsetY = (screenHeight + 36 - 5) / 2;
        int width = this.getWidth(ThermometerBarRenderer.temp);
        GuiHelper.drawLayer(poseStack, offsetX + 1, offsetY + 1, new TexturePos(1, 10, width, 3));
        GuiHelper.drawLayer(poseStack, offsetX, offsetY, new TexturePos(0, 14, 31, 5));
        RenderSystem.m_69461_();
    }

    public int getWidth(float temp) {
        Temperature t = Temperature.getTemperatureLevel(temp);
        if (temp <= 0.0f) {
            return 0;
        }
        if (temp <= Temperature.FREEZING.getMax()) {
            return Math.round(5.0f * temp / 0.15f);
        }
        if (temp > Temperature.HEAT.getMin()) {
            int id = t.getId() - 1;
            float width = id * 5;
            return Math.round(width += 5.0f * (temp -= t.getMin()) / 0.35f);
        }
        int id = t.getId() - 1;
        float width = id * 5;
        return Math.round(width += 5.0f * (temp -= t.getMin()) / t.getWidth());
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (level - 0.0078125f > temp) {
            temp += 0.01f;
        } else if (level + 0.0078125f < temp) {
            temp -= 0.01f;
        }
    }
}

