/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.silveroak.client.gui.hud;

import cloud.lemonslice.silveroak.client.texture.TexturePos;
import cloud.lemonslice.silveroak.helper.GuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="silveroakoutpost")
public class RainGaugeBarRenderer
extends GuiComponent {
    private static final ResourceLocation OVERLAY_BAR = new ResourceLocation("silveroakoutpost", "textures/gui/hud/env.png");
    private static final int WIDTH = 31;
    private static final int HEIGHT = 5;
    private static float rainfall = 0.0f;
    private static float level = 0.0f;

    public void renderStatusBar(PoseStack poseStack, int screenWidth, int screenHeight, float rainfall) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAY_BAR);
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        level = rainfall;
        int offsetX = (screenWidth - 31 + 1) / 2;
        int offsetY = (screenHeight + 36 - 5) / 2;
        int width = this.getWidth(RainGaugeBarRenderer.rainfall);
        GuiHelper.drawLayer(poseStack, offsetX + 1, offsetY + 1, new TexturePos(1, 0, width, 3));
        GuiHelper.drawLayer(poseStack, offsetX, offsetY, new TexturePos(0, 4, 31, 5));
        RenderSystem.m_69461_();
    }

    public int getWidth(float rainfall) {
        int width = 0;
        if (rainfall <= 0.0f) {
            return width;
        }
        if (rainfall <= 1.0f) {
            return Math.round(29.0f * rainfall);
        }
        return 29;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            if (level - 0.0078125f > rainfall) {
                rainfall += 0.01f;
            } else if (level + 0.0078125f < rainfall) {
                rainfall -= 0.01f;
            }
        }
    }
}

