/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.event;

import com.endlesnights.torchslabsmod.blocks.vanilla.BlockWallTorchSlab;
import com.endlesnights.torchslabsmod.config.Config;
import com.endlesnights.torchslabsmod.config.TorchSlabConfig;
import com.mojang.math.Vector3d;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StoneButtonBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="torchslabmod")
public class PlaceHandlerTorchWall {
    private static final HashMap<ResourceLocation, Block> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        ResourceLocation rl = held.m_41720_().getRegistryName();
        if (PLACE_ENTRIES.containsKey(rl)) {
            PlaceHandlerTorchWall.placeTorch(event, held, PLACE_ENTRIES.get(rl));
        }
    }

    private static void placeTorch(PlayerInteractEvent.RightClickBlock event, ItemStack held, Block block) {
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        BlockPos placeAt = pos.m_142300_(face);
        Level world = event.getWorld();
        Player playerIn = event.getPlayer();
        Config.loadConfig(Config.SERVER, FMLPaths.CONFIGDIR.get().resolve("torchslabmod-server.toml").toString());
        if (!playerIn.m_20161_() && ((List)TorchSlabConfig.interactiveCheckList.get()).contains(world.m_8055_(pos).m_60734_().getRegistryName().toString())) {
            return;
        }
        if (face != Direction.UP && face != Direction.DOWN && Block.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)face) && (world.m_46859_(placeAt) || world.m_8055_(placeAt).m_60734_() == Blocks.f_49990_ || world.m_6425_(placeAt).m_76152_() == Fluids.f_76192_)) {
            if (PlaceHandlerTorchWall.blockHalf(playerIn, pos, face) >= 0.0 && PlaceHandlerTorchWall.validTop(world.m_8055_(placeAt.m_7494_()), (BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.TOP))) {
                if (!((Boolean)TorchSlabConfig.upperBlockCheck.get()).booleanValue()) {
                    return;
                }
                if (block instanceof SimpleWaterloggedBlock) {
                    world.m_46597_(placeAt, (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.TOP)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(placeAt).m_76152_() == Fluids.f_76193_)));
                } else {
                    world.m_46597_(placeAt, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.TOP));
                }
            } else {
                return;
            }
            SoundType soundType = block.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)event.getPlayer());
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_() - 0.2f);
            event.getPlayer().m_6674_(event.getHand());
            if (!event.getPlayer().m_7500_()) {
                held.m_41774_(1);
            }
            event.setCanceled(true);
        } else if ((world.m_8055_(pos).m_60734_() instanceof SlabBlock && world.m_8055_(pos).m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM || world.m_8055_(pos).m_60734_() instanceof StairBlock && world.m_8055_(pos).m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM) && face != Direction.UP && face != Direction.DOWN && (world.m_46859_(placeAt) || world.m_8055_(placeAt).m_60734_() == Blocks.f_49990_ || world.m_6425_(placeAt).m_76152_() == Fluids.f_76192_)) {
            SoundType soundType = block.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)event.getPlayer());
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_() - 0.2f);
            event.getPlayer().m_6674_(event.getHand());
            if (block instanceof SimpleWaterloggedBlock) {
                world.m_46597_(placeAt, (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(placeAt).m_76152_() == Fluids.f_76193_)));
            } else {
                world.m_46597_(placeAt, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.BOTTOM));
            }
            if (!event.getPlayer().m_7500_()) {
                held.m_41774_(1);
            }
            event.setCanceled(true);
        } else if ((world.m_8055_(pos).m_60734_() instanceof SlabBlock && world.m_8055_(pos).m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP || world.m_8055_(pos).m_60734_() instanceof StairBlock && world.m_8055_(pos).m_61143_((Property)StairBlock.f_56842_) == Half.TOP) && face != Direction.UP && face != Direction.DOWN && (world.m_46859_(placeAt) || world.m_8055_(placeAt).m_60734_() == Blocks.f_49990_ || world.m_6425_(placeAt).m_76152_() == Fluids.f_76192_) && PlaceHandlerTorchWall.validTop(world.m_8055_(placeAt.m_7494_()), (BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.TOP))) {
            SoundType soundType = block.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)event.getPlayer());
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_() - 0.2f);
            event.getPlayer().m_6674_(event.getHand());
            if (block instanceof SimpleWaterloggedBlock) {
                world.m_46597_(placeAt, (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.TOP)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(placeAt).m_76152_() == Fluids.f_76193_)));
            } else {
                world.m_46597_(placeAt, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)face)).m_61124_(BlockWallTorchSlab.HALF, (Comparable)Half.TOP));
            }
            if (!event.getPlayer().m_7500_()) {
                held.m_41774_(1);
            }
            event.setCanceled(true);
        }
    }

    static boolean validTop(BlockState state, BlockState torchState) {
        return state.m_60734_() instanceof AirBlock || state.m_60734_() instanceof LiquidBlock || state.m_60734_() instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP || state.m_60734_() instanceof StairBlock && state.m_61143_((Property)StairBlock.f_56842_) == Half.TOP && state.m_61143_((Property)StairBlock.f_56841_) == torchState.m_61143_((Property)BlockWallTorchSlab.f_58119_) || state.m_60734_() instanceof EndRodBlock || state.m_60734_() instanceof TorchBlock || state.m_60734_() instanceof WallSignBlock || state.m_60734_() instanceof LadderBlock || state.m_60734_() instanceof WebBlock || state.m_60734_() instanceof VineBlock || state.m_60734_() instanceof RedstoneWallTorchBlock || state.m_60734_() instanceof StoneButtonBlock || state.m_60734_() instanceof WoodButtonBlock;
    }

    static double blockHalf(Player playerIn, BlockPos pos, Direction face) {
        double angleX = Math.toRadians(playerIn.m_146908_());
        double angleY = Math.toRadians(playerIn.m_146909_());
        double sinYaw = Math.sin(angleX);
        double cosYaw = Math.cos(angleX);
        double sinPitch = Math.sin(angleY);
        double cosPitch = Math.cos(angleY);
        Vector3d directionAngle = new Vector3d(cosPitch * cosYaw, sinPitch, cosPitch * sinYaw);
        Double yOffset = playerIn.m_20299_((float)1.0f).f_82480_ - ((double)pos.m_123342_() + 0.5);
        if (face == Direction.NORTH) {
            double magnatude = (playerIn.m_20299_((float)1.0f).f_82481_ - (double)pos.m_123343_()) / directionAngle.f_86214_;
            return magnatude * directionAngle.f_86215_ + yOffset;
        }
        if (face == Direction.SOUTH) {
            double magnatude = (playerIn.m_20299_((float)1.0f).f_82481_ - (double)(pos.m_123343_() + 1)) / directionAngle.f_86214_;
            return magnatude * directionAngle.f_86215_ + yOffset;
        }
        if (face == Direction.WEST) {
            double magnatude = (playerIn.m_20299_((float)1.0f).f_82479_ - (double)pos.m_123341_()) / -directionAngle.f_86216_;
            return magnatude * directionAngle.f_86215_ + yOffset;
        }
        if (face == Direction.EAST) {
            double magnatude = (playerIn.m_20299_((float)1.0f).f_82479_ - (double)(pos.m_123341_() + 1)) / -directionAngle.f_86216_;
            return magnatude * directionAngle.f_86215_ + yOffset;
        }
        return 0.0;
    }

    public static void registerPlaceEntry(ResourceLocation itemName, Block torchSlab) {
        if (!PLACE_ENTRIES.containsKey(itemName) && torchSlab != null) {
            PLACE_ENTRIES.put(itemName, torchSlab);
        }
    }

    public static Collection<Block> getPlaceEntryBlocks() {
        return PLACE_ENTRIES.values();
    }
}

