/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.event;

import java.util.Collection;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="torchslabmod")
public class PlaceHandlerPadLights {
    private static final HashMap<ResourceLocation, Block> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        ResourceLocation rl = held.m_41720_().getRegistryName();
        if (PLACE_ENTRIES.containsKey(rl)) {
            PlaceHandlerPadLights.placeLight(event, held, PLACE_ENTRIES.get(rl));
        }
    }

    private static void placeLight(PlayerInteractEvent.RightClickBlock event, ItemStack held, Block block) {
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        Level world = event.getWorld();
        if (world.m_8055_(pos).m_60734_() instanceof WaterlilyBlock && face == Direction.UP) {
            world.m_46597_(pos, (BlockState)block.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)event.getPlayer().m_6350_()));
            SoundType soundType = block.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)event.getPlayer());
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_() - 0.2f);
            event.getPlayer().m_6674_(event.getHand());
            if (!event.getPlayer().m_7500_()) {
                held.m_41774_(1);
            }
            event.setCanceled(true);
        }
    }

    public static void registerPlaceEntry(ResourceLocation itemName, Block padLight) {
        if (!PLACE_ENTRIES.containsKey(itemName) && padLight != null) {
            PLACE_ENTRIES.put(itemName, padLight);
        }
    }

    public static Collection<Block> getPlaceEntryBlocks() {
        return PLACE_ENTRIES.values();
    }
}

