/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.blocks.vanilla;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPadCandle
extends CandleBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final VoxelShape PAD_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);
    private static final VoxelShape ONE_AABB = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0), (VoxelShape)PAD_SHAPE, (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape TWO_AABB = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)6.0, (double)9.0), (VoxelShape)PAD_SHAPE, (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape THREE_AABB = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)11.0), (VoxelShape)PAD_SHAPE, (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape FOUR_AABB = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)10.0), (VoxelShape)PAD_SHAPE, (BooleanOp)BooleanOp.f_82695_);
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.m_137537_(() -> {
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        int2objectmap.defaultReturnValue((Object)ImmutableList.of());
        int2objectmap.put(1, List.of(new Vec3(0.5, 0.5, 0.5)));
        int2objectmap.put(2, List.of(new Vec3(0.375, 0.44, 0.5), new Vec3(0.625, 0.5, 0.44)));
        int2objectmap.put(3, List.of(new Vec3(0.5, 0.313, 0.625), new Vec3(0.375, 0.44, 0.5), new Vec3(0.56, 0.5, 0.44)));
        int2objectmap.put(4, List.of(new Vec3(0.44, 0.313, 0.56), new Vec3(0.625, 0.44, 0.56), new Vec3(0.375, 0.44, 0.375), new Vec3(0.56, 0.5, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2objectmap);
    });
    private Item pickerItem;

    public BlockPadCandle(BlockBehaviour.Properties properties, Item item) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)f_152790_, (Comparable)Integer.valueOf(1))).m_61124_((Property)f_152791_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_152792_, (Comparable)Boolean.valueOf(false)));
        this.pickerItem = item;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, f_152790_, f_152791_, f_152792_});
    }

    public VoxelShape m_5940_(BlockState p_152817_, BlockGetter p_152818_, BlockPos p_152819_, CollisionContext p_152820_) {
        switch ((Integer)p_152817_.m_61143_((Property)f_152790_)) {
            default: {
                return BlockPadCandle.rotateShape((Direction)this.m_49966_().m_61143_((Property)FACING), (Direction)p_152817_.m_61143_((Property)FACING), ONE_AABB);
            }
            case 2: {
                return BlockPadCandle.rotateShape((Direction)this.m_49966_().m_61143_((Property)FACING), (Direction)p_152817_.m_61143_((Property)FACING), TWO_AABB);
            }
            case 3: {
                return BlockPadCandle.rotateShape((Direction)this.m_49966_().m_61143_((Property)FACING), (Direction)p_152817_.m_61143_((Property)FACING), THREE_AABB);
            }
            case 4: 
        }
        return BlockPadCandle.rotateShape((Direction)this.m_49966_().m_61143_((Property)FACING), (Direction)p_152817_.m_61143_((Property)FACING), FOUR_AABB);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_166049_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Integer)state.m_61143_((Property)f_152790_)) {
            default: {
                return BlockPadCandle.rotateShape((Direction)this.m_49966_().m_61143_((Property)FACING), (Direction)state.m_61143_((Property)FACING), ONE_AABB);
            }
            case 2: {
                return BlockPadCandle.rotateShape((Direction)this.m_49966_().m_61143_((Property)FACING), (Direction)state.m_61143_((Property)FACING), TWO_AABB);
            }
            case 3: {
                return BlockPadCandle.rotateShape((Direction)this.m_49966_().m_61143_((Property)FACING), (Direction)state.m_61143_((Property)FACING), THREE_AABB);
            }
            case 4: 
        }
        return BlockPadCandle.rotateShape((Direction)this.m_49966_().m_61143_((Property)FACING), (Direction)state.m_61143_((Property)FACING), FOUR_AABB);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos blockpos) {
        return this.mayPlaceOn(worldIn.m_8055_(blockpos.m_7495_()), (BlockGetter)worldIn, blockpos.m_7495_());
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter worldIn, BlockPos pos) {
        FluidState fluidstate = worldIn.m_6425_(pos);
        FluidState fluidstate1 = worldIn.m_6425_(pos.m_7494_());
        return (fluidstate.m_76152_() == Fluids.f_76193_ || state.m_60767_() == Material.f_76276_) && fluidstate1.m_76152_() == Fluids.f_76191_;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !this.m_7898_(stateIn, (LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    protected Iterable<Vec3> m_142199_(BlockState p_152812_) {
        if (p_152812_.m_61143_((Property)FACING) == Direction.NORTH) {
            return (Iterable)PARTICLE_OFFSETS.get(((Integer)p_152812_.m_61143_((Property)f_152790_)).intValue());
        }
        ArrayList<Vec3> vecList = new ArrayList<Vec3>();
        for (Vec3 v : (List)PARTICLE_OFFSETS.get(((Integer)p_152812_.m_61143_((Property)f_152790_)).intValue())) {
            float angle = 1.5708f;
            if (p_152812_.m_61143_((Property)FACING) == Direction.EAST) {
                angle = -1.5708f;
            } else if (p_152812_.m_61143_((Property)FACING) == Direction.SOUTH) {
                angle = 3.1416f;
            }
            Vec3 newV = new Vec3(Math.cos(angle) * (v.f_82479_ - 0.5) + Math.sin(angle) * (v.f_82481_ - 0.5) + 0.5, v.f_82480_, Math.cos(angle) * (v.f_82481_ - 0.5) - Math.sin(angle) * (v.f_82479_ - 0.5) + 0.5);
            vecList.add(newV);
        }
        return vecList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState p_151929_, Level p_151930_, BlockPos p_151931_, Random p_151932_) {
        if (((Boolean)p_151929_.m_61143_((Property)f_152791_)).booleanValue()) {
            this.m_142199_(p_151929_).forEach(p_151917_ -> BlockPadCandle.addParticlesAndSound(p_151930_, p_151917_.m_82520_((double)p_151931_.m_123341_(), (double)p_151931_.m_123342_(), (double)p_151931_.m_123343_()), p_151932_));
        }
    }

    private static void addParticlesAndSound(Level p_151910_, Vec3 p_151911_, Random p_151912_) {
        float f = p_151912_.nextFloat();
        if (f < 0.3f) {
            p_151910_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, p_151911_.f_82479_, p_151911_.f_82480_, p_151911_.f_82481_, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                p_151910_.m_7785_(p_151911_.f_82479_ + 0.5, p_151911_.f_82480_ + 0.5, p_151911_.f_82481_ + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + p_151912_.nextFloat(), p_151912_.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        p_151910_.m_7106_((ParticleOptions)ParticleTypes.f_175834_, p_151911_.f_82479_, p_151911_.f_82480_, p_151911_.f_82481_, 0.0, 0.0, 0.0);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult p_225533_6_) {
        ItemStack itemStack = playerIn.m_21120_(hand);
        if (itemStack.m_41720_() instanceof FlintAndSteelItem) {
            return BlockPadCandle.onItemUseFlint(state, worldIn, pos, playerIn, hand, p_225533_6_);
        }
        return super.m_6227_(state, worldIn, pos, playerIn, hand, p_225533_6_);
    }

    public static InteractionResult onItemUseFlint(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult p_225533_6_) {
        UseOnContext context = new UseOnContext(playerIn, hand, p_225533_6_);
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CandleBlock.f_152790_, (Comparable)((Integer)state.m_61143_((Property)CandleBlock.f_152790_)))).m_61124_((Property)CandleBlock.f_152792_, (Comparable)((Boolean)state.m_61143_((Property)CandleBlock.f_152792_)));
        if (blockstate != null) {
            Player playerentity = context.m_43723_();
            world.m_5594_(playerentity, blockpos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_46597_(blockpos, blockstate);
            if (playerentity != null) {
                context.m_43722_().m_41622_(1, (LivingEntity)playerentity, p_220043_1_ -> p_220043_1_.m_21190_(context.m_43724_()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.AIR && !this.f_60443_ ? true : super.m_7357_(state, worldIn, pos, type);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.pickerItem);
    }

    public static class ColorHandler
    implements BlockColor {
        public int m_92566_(BlockState state, @Nullable BlockAndTintGetter reader, @Nullable BlockPos blockPos, int tintIndex) {
            if (reader != null && blockPos != null) {
                return BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)blockPos);
            }
            return GrassColor.m_46415_((double)0.5, (double)1.0);
        }
    }
}

