/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.utils;

import com.mojang.math.Vector3f;
import io.github.mortuusars.chalk.render.ChalkColors;
import io.github.mortuusars.chalk.utils.PositionUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class ParticleUtils {
    public static void spawnParticle(Level world, ParticleOptions particleType, Vector3f position, Vector3f velocity, int count) {
        if (!world.m_5776_() || count < 1) {
            return;
        }
        Random random = new Random();
        for (int i = 0; i < count; ++i) {
            world.m_7106_(particleType, (double)position.m_122239_() + (double)(random.nextFloat() - 0.5f) * 0.3, (double)position.m_122260_() + (double)(random.nextFloat() - 0.5f) * 0.3, (double)position.m_122269_() + (double)(random.nextFloat() - 0.5f) * 0.3, (double)velocity.m_122239_(), (double)velocity.m_122260_(), (double)velocity.m_122269_());
        }
    }

    public static void spawnParticle(Level world, ParticleOptions particleType, Vector3f position, int count) {
        ParticleUtils.spawnParticle(world, particleType, position, new Vector3f(0.0f, 0.0f, 0.0f), count);
    }

    public static void spawnColorDustParticles(DyeColor color, Level level, BlockPos pos, Direction face) {
        int colorValue = ChalkColors.fromDyeColor(color);
        float R = (colorValue & 0xFF0000) >> 16;
        float G = (colorValue & 0xFF00) >> 8;
        float B = colorValue & 0xFF;
        ParticleUtils.spawnParticle(level, (ParticleOptions)new DustParticleOptions(new Vector3f(R / 255.0f, G / 255.0f, B / 255.0f), 2.0f), PositionUtils.blockCenterOffsetToFace(pos, face, 0.25f), 1);
    }
}

