/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.utils;

import java.awt.geom.Point2D;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class ClickLocationUtils {
    public static int getBlockRegion(Vec3 clickLocation, BlockPos pos, Direction facing) {
        Point2D.Double point = ClickLocationUtils.getClickedBlockSpaceCoords(clickLocation, pos, facing);
        int xRegion = Math.min(2, (int)(point.x / 0.333));
        int yRegion = Math.min(2, (int)(point.y / 0.333));
        int[][] blockRegions = new int[][]{{0, 1, 2}, {3, 4, 5}, {6, 7, 8}};
        return blockRegions[yRegion][xRegion];
    }

    public static Point2D.Double getClickedBlockSpaceCoords(Vec3 clickLocation, BlockPos pos, Direction facing) {
        double x = clickLocation.f_82479_ - (double)pos.m_123341_();
        double y = clickLocation.f_82480_ - (double)pos.m_123342_();
        double z = clickLocation.f_82481_ - (double)pos.m_123343_();
        return switch (facing) {
            case Direction.NORTH -> new Point2D.Double(1.0 - x, 1.0 - y);
            case Direction.SOUTH -> new Point2D.Double(x, 1.0 - y);
            case Direction.WEST -> new Point2D.Double(z, 1.0 - y);
            case Direction.EAST -> new Point2D.Double(1.0 - z, 1.0 - y);
            default -> new Point2D.Double(x, z);
        };
    }
}

