/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.render;

import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.blocks.ChalkMarkBlock;
import io.github.mortuusars.chalk.render.ChalkMarkBakedModel;
import io.github.mortuusars.chalk.render.ChalkMarkBlockColor;
import io.github.mortuusars.chalk.setup.ModBlocks;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class Rendering {
    public static final ChalkMarkBlockColor CHALK_MARK_BLOCK_COLOR = new ChalkMarkBlockColor();

    @SubscribeEvent
    public static void onModelBakeEvent(ModelBakeEvent event) {
        ModBlocks.MARKS.forEach((name, block) -> {
            for (BlockState blockState : ((ChalkMarkBlock)((Object)((Object)block.get()))).m_49965_().m_61056_()) {
                ModelResourceLocation variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
                BakedModel existingModel = (BakedModel)event.getModelRegistry().get(variantMRL);
                if (existingModel == null) {
                    Chalk.LOGGER.warn("Did not find the expected vanilla baked model(s) for " + block + " in registry");
                    continue;
                }
                if (existingModel instanceof ChalkMarkBakedModel) {
                    Chalk.LOGGER.warn("Tried to replace " + block + " twice");
                    continue;
                }
                ChalkMarkBakedModel customModel = new ChalkMarkBakedModel(existingModel);
                event.getModelRegistry().put(variantMRL, customModel);
            }
        });
    }

    @SubscribeEvent
    public static void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        ModBlocks.MARKS.forEach((name, block) -> blockColors.m_92589_((BlockColor)CHALK_MARK_BLOCK_COLOR, new Block[]{(Block)block.get()}));
    }

    @SubscribeEvent
    public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_() == TextureAtlas.f_118259_) {
            event.addSprite(new ResourceLocation("chalk:block/mark_arrow"));
            event.addSprite(new ResourceLocation("chalk:block/mark_center"));
            event.addSprite(new ResourceLocation("chalk:block/mark_cross"));
        }
    }

    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent event) {
        Rendering.setRenderLayerForMarks();
    }

    private static void setRenderLayerForMarks() {
        ModBlocks.MARKS.forEach((name, block) -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
    }
}

