/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.render;

import com.mojang.math.Vector3f;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.blocks.ChalkMarkBlock;
import io.github.mortuusars.chalk.blocks.MarkSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class ChalkMarkBakedModel
implements BakedModel {
    public static ModelProperty<Integer> ORIENTATION = new ModelProperty();
    public static ModelProperty<Direction> FACING = new ModelProperty();
    public static ModelProperty<Boolean> GLOWING = new ModelProperty();
    public static ModelProperty<MarkSymbol> SYMBOL = new ModelProperty();
    private static final FaceBakery _faceBakery = new FaceBakery();
    private final BakedModel _baseModel;

    public ChalkMarkBakedModel(BakedModel baseModel) {
        this._baseModel = baseModel;
    }

    public static ModelDataMap getEmptyModelData() {
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        builder.withInitial(ORIENTATION, (Object)4);
        builder.withInitial(FACING, (Object)Direction.UP);
        builder.withInitial(GLOWING, (Object)false);
        builder.withInitial(SYMBOL, (Object)MarkSymbol.NONE);
        ModelDataMap modelDataMap = builder.build();
        return modelDataMap;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        int orientation = (Integer)state.m_61143_((Property)ChalkMarkBlock.ORIENTATION);
        Direction facing = (Direction)state.m_61143_((Property)ChalkMarkBlock.FACING);
        boolean glowing = (Boolean)state.m_61143_((Property)ChalkMarkBlock.GLOWING);
        MarkSymbol symbol = (MarkSymbol)((Object)state.m_61143_(ChalkMarkBlock.SYMBOL));
        ModelDataMap modelDataMap = ChalkMarkBakedModel.getEmptyModelData();
        modelDataMap.setData(ORIENTATION, (Object)orientation);
        modelDataMap.setData(FACING, (Object)facing);
        modelDataMap.setData(GLOWING, (Object)glowing);
        modelDataMap.setData(SYMBOL, (Object)symbol);
        return modelDataMap;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side != null) {
            return Collections.EMPTY_LIST;
        }
        if (!extraData.hasProperty(ORIENTATION)) {
            Chalk.LOGGER.error("IModelData did not have expected property: ORIENTATION");
            return this._baseModel.getQuads(state, side, rand, extraData);
        }
        if (!extraData.hasProperty(FACING)) {
            Chalk.LOGGER.error("IModelData did not have expected property: FACING");
            return this._baseModel.getQuads(state, side, rand, extraData);
        }
        if (!extraData.hasProperty(GLOWING)) {
            Chalk.LOGGER.error("IModelData did not have expected property: GLOWING");
            return this._baseModel.getQuads(state, side, rand, extraData);
        }
        int orientation = (Integer)extraData.getData(ORIENTATION);
        Direction facing = (Direction)extraData.getData(FACING);
        boolean isGlowing = (Boolean)extraData.getData(GLOWING);
        MarkSymbol symbol = MarkSymbol.NONE;
        if (extraData.hasProperty(SYMBOL)) {
            symbol = (MarkSymbol)((Object)extraData.getData(SYMBOL));
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BakedQuad quad = this.getQuadByFacing(facing, orientation, symbol);
        if (isGlowing) {
            quad = ChalkMarkBakedModel.convertToFullBright(quad);
        }
        quads.add(quad);
        return quads;
    }

    private static BakedQuad convertToFullBright(BakedQuad quad) {
        int[] vertexData = (int[])quad.m_111303_().clone();
        int step = vertexData.length / 4;
        vertexData[6] = 0xF000F0;
        vertexData[6 + step] = 0xF000F0;
        vertexData[6 + 2 * step] = 0xF000F0;
        vertexData[6 + 3 * step] = 0xF000F0;
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), false);
    }

    private BakedQuad getQuadByFacing(Direction facing, int orientation, MarkSymbol symbol) {
        switch (facing) {
            case DOWN: {
                return this.getBakedQuad(facing, symbol, orientation, new Vector3f(0.0f, 15.9f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), 180);
            }
            case UP: {
                return this.getBakedQuad(facing, symbol, orientation, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 0.1f, 16.0f), 0);
            }
            case NORTH: {
                return this.getBakedQuad(facing, symbol, orientation, new Vector3f(0.0f, 0.0f, 15.9f), new Vector3f(16.0f, 16.0f, 16.0f), 0);
            }
            case SOUTH: {
                return this.getBakedQuad(facing, symbol, orientation, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 0.1f), 0);
            }
            case WEST: {
                return this.getBakedQuad(facing, symbol, orientation, new Vector3f(15.9f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), 0);
            }
            case EAST: {
                return this.getBakedQuad(facing, symbol, orientation, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 16.0f, 16.0f), 0);
            }
        }
        return this.getBakedQuad(facing, symbol, orientation, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 0.1f, 16.0f), 0);
    }

    private BakedQuad getBakedQuad(Direction facing, MarkSymbol symbol, int orientation, Vector3f from, Vector3f to, int uvRotation) {
        int rotation;
        TextureAtlasSprite texture = this.getTextureForMark(symbol, orientation);
        BlockElementFace blockPartFace = new BlockElementFace(facing, 0, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, uvRotation));
        int n = rotation = symbol == MarkSymbol.CROSS ? 45 : this.rotationFromOrientation(orientation);
        if (facing == Direction.NORTH || facing == Direction.WEST) {
            rotation = 360 - rotation;
        }
        BlockElementRotation blockPartRotation = new BlockElementRotation(new Vector3f(0.5f, 0.5f, 0.5f), facing.m_122434_(), (float)rotation, false);
        BakedQuad quad = _faceBakery.m_111600_(from, to, blockPartFace, texture, facing, (ModelState)SimpleModelState.IDENTITY, blockPartRotation, true, new ResourceLocation("chalk:chalk_mark_" + facing));
        return quad;
    }

    private TextureAtlasSprite getTextureForMark(MarkSymbol symbol, int orientation) {
        TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_);
        if (symbol == MarkSymbol.CROSS) {
            return atlas.m_118316_(new ResourceLocation("chalk:block/mark_cross"));
        }
        if (orientation == 4) {
            return atlas.m_118316_(new ResourceLocation("chalk:block/mark_center"));
        }
        return atlas.m_118316_(new ResourceLocation("chalk:block/mark_arrow"));
    }

    private int rotationFromOrientation(int orientation) {
        if (orientation < 0 || orientation > 8) {
            throw new IllegalArgumentException("Orientation should be 0-8. Passed: " + orientation);
        }
        switch (orientation) {
            case 2: {
                return 315;
            }
            case 5: {
                return 270;
            }
            case 8: {
                return 225;
            }
            case 7: {
                return 180;
            }
            case 6: {
                return 135;
            }
            case 3: {
                return 90;
            }
            case 0: {
                return 45;
            }
        }
        return 0;
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState p_200117_1_, @Nullable Direction p_200117_2_, Random p_200117_3_) {
        return Collections.EMPTY_LIST;
    }

    public boolean m_7541_() {
        return this._baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this._baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return this._baseModel.m_7547_();
    }

    public boolean m_7521_() {
        return this._baseModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this._baseModel.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this._baseModel.m_7343_();
    }

    private static enum MarkType {
        CENTER,
        ARROW,
        CROSS;

    }
}

