/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.menus;

import io.github.mortuusars.chalk.config.CommonConfig;
import io.github.mortuusars.chalk.items.ChalkBox;
import io.github.mortuusars.chalk.menus.ChalkBoxItemStackHandler;
import io.github.mortuusars.chalk.setup.ModMenus;
import java.awt.Point;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChalkBoxMenu
extends AbstractContainerMenu {
    public final ItemStack chalkBoxStack;
    public Point chalkBoxCoords = null;
    private int chalkBoxSlotId;

    public ChalkBoxMenu(int pContainerId, Inventory playerInventory, ItemStack chalkBoxStack, @Nullable IItemHandler itemHandler) {
        super((MenuType)ModMenus.CHALK_BOX.get(), pContainerId);
        this.chalkBoxStack = chalkBoxStack;
        boolean glowingEnabled = (Boolean)CommonConfig.CHALK_BOX_GLOWING.get();
        int slotsYPos = glowingEnabled ? 18 : 33;
        this.chalkBoxSlotId = playerInventory.m_36030_(chalkBoxStack);
        int index = 0;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 4; ++column) {
                if (index >= 8) {
                    throw new IllegalStateException("Chalk slot ids should go before Glowing Item slot id and not exceed it.");
                }
                this.m_38897_((Slot)new SlotItemHandler(itemHandler, index++, column * 18 + 53, row * 18 + slotsYPos));
            }
        }
        if (glowingEnabled) {
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 8, 80, 68));
        }
        this.addPlayerSlots(playerInventory);
    }

    public static ChalkBoxMenu fromBuffer(int containerID, Inventory playerInventory, FriendlyByteBuf dataBuffer) {
        ItemStack chalkBoxStack = dataBuffer.m_130267_().m_41777_();
        ChalkBoxItemStackHandler itemHandler = new ChalkBoxItemStackHandler(chalkBoxStack);
        return new ChalkBoxMenu(containerID, playerInventory, chalkBoxStack, (IItemHandler)itemHandler);
    }

    public int getGlowingUses() {
        return ChalkBox.getGlowingUses(this.chalkBoxStack);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotItemStack = slot.m_7993_();
            itemstack = slotItemStack.m_41777_();
            if (index < 9 ? !this.m_38903_(slotItemStack, 9, this.f_38839_.size(), true) : !this.m_38903_(slotItemStack, 0, 9, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItemStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return player.m_150109_().m_36030_(this.chalkBoxStack) == this.chalkBoxSlotId;
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int chalkBoxSlotId = playerInventory.m_36030_(this.chalkBoxStack);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + row * 9 + 9;
                if (index == chalkBoxSlotId) {
                    this.chalkBoxCoords = new Point(column * 18 + 8, 98 + row * 18);
                    continue;
                }
                this.m_38897_(new Slot((Container)playerInventory, index, column * 18 + 8, 98 + row * 18));
            }
        }
        for (int index = 0; index < 9; ++index) {
            if (index == chalkBoxSlotId) {
                this.chalkBoxCoords = new Point(index * 18 + 8, 156);
                continue;
            }
            this.m_38897_(new Slot((Container)playerInventory, index, index * 18 + 8, 156));
        }
    }
}

