/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.items;

import io.github.mortuusars.chalk.blocks.MarkSymbol;
import io.github.mortuusars.chalk.config.CommonConfig;
import io.github.mortuusars.chalk.core.ChalkMark;
import io.github.mortuusars.chalk.setup.ModSoundEvents;
import io.github.mortuusars.chalk.setup.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChalkItem
extends Item {
    private final DyeColor color;

    public ChalkItem(DyeColor dyeColor, Item.Properties properties) {
        super(properties.m_41491_(CreativeModeTab.f_40756_).m_41487_(1).m_41499_(64).setNoRepair());
        this.color = dyeColor;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)CommonConfig.CHALK_DURABILITY.get();
    }

    public DyeColor getColor() {
        return this.color;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_36341_()) {
            return this.m_6225_(context);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        MarkSymbol symbol;
        InteractionHand hand = context.m_43724_();
        ItemStack itemStack = context.m_43722_();
        Player player = context.m_43723_();
        if (player == null || !(itemStack.m_41720_() instanceof ChalkItem)) {
            return InteractionResult.FAIL;
        }
        if (hand == InteractionHand.OFF_HAND && player.m_21205_().m_41720_() instanceof ChalkItem) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        boolean isGlowing = player.m_21206_().m_204117_(ModTags.Items.GLOWING);
        MarkSymbol markSymbol = symbol = context.m_7078_() ? MarkSymbol.CROSS : MarkSymbol.NONE;
        if (ChalkMark.draw(symbol, this.color, isGlowing, clickedPos, clickedFace, context.m_43720_(), level) == InteractionResult.SUCCESS) {
            if (!player.m_7500_()) {
                this.damageAndConsumeItems(hand, itemStack, player, level, isGlowing);
            }
            return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        }
        return InteractionResult.FAIL;
    }

    private void damageAndConsumeItems(InteractionHand hand, ItemStack itemStack, Player player, Level level, boolean isGlowing) {
        if (!itemStack.m_41763_()) {
            return;
        }
        itemStack.m_41721_(itemStack.m_41773_() + 1);
        if (itemStack.m_41773_() >= itemStack.m_41776_()) {
            player.m_21008_(hand, ItemStack.f_41583_);
            Vec3 playerPos = player.m_20182_();
            level.m_6263_(player, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, (SoundEvent)ModSoundEvents.CHALK_BROKEN.get(), SoundSource.PLAYERS, 0.9f, 0.9f + level.f_46441_.nextFloat() * 0.2f);
        }
        if (isGlowing) {
            player.m_21206_().m_41774_(1);
        }
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }
}

