/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.items;

import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.chalk.blocks.MarkSymbol;
import io.github.mortuusars.chalk.core.ChalkMark;
import io.github.mortuusars.chalk.items.ChalkBox;
import io.github.mortuusars.chalk.items.ChalkItem;
import io.github.mortuusars.chalk.menus.ChalkBoxItemStackHandler;
import io.github.mortuusars.chalk.menus.ChalkBoxMenu;
import io.github.mortuusars.chalk.setup.ModSoundEvents;
import io.github.mortuusars.chalk.setup.ModTags;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChalkBoxItem
extends Item {
    public ChalkBoxItem(Item.Properties properties) {
        super(properties.setNoRepair());
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        Pair<ItemStack, Integer> firstChalkStack = this.getFirstChalkStack(pStack);
        if (firstChalkStack != null) {
            pTooltipComponents.add((Component)new TranslatableComponent("item.chalk.chalk_box.tooltip.drawing_with").m_130940_(ChatFormatting.GRAY).m_7220_((Component)((BaseComponent)((ItemStack)firstChalkStack.getFirst()).m_41786_()).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.WHITE)));
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_36341_()) {
            return this.m_6225_(context);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        boolean isGlowing;
        ItemStack chalkBoxStack = context.m_43722_();
        if (!chalkBoxStack.m_150930_((Item)this)) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (context.m_43724_() == InteractionHand.OFF_HAND && (player.m_21205_().m_204117_(ModTags.Items.CHALK) || player.m_21205_().m_150930_((Item)this))) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        Pair<ItemStack, Integer> chalkStack = this.getFirstChalkStack(chalkBoxStack);
        if (chalkStack == null || !ChalkMark.canBeDrawnAt(clickedPos.m_142300_(clickedFace), clickedPos, clickedFace, level)) {
            return InteractionResult.FAIL;
        }
        MarkSymbol symbol = context.m_7078_() ? MarkSymbol.CROSS : MarkSymbol.NONE;
        DyeColor chalkColor = ((ChalkItem)((ItemStack)chalkStack.getFirst()).m_41720_()).getColor();
        boolean bl = isGlowing = ChalkBox.getGlowingUses(chalkBoxStack) > 0;
        if (ChalkMark.draw(symbol, chalkColor, isGlowing, clickedPos, clickedFace, context.m_43720_(), level) == InteractionResult.SUCCESS) {
            if (!player.m_7500_()) {
                ItemStack chalkItemStack = (ItemStack)chalkStack.getFirst();
                if (chalkItemStack.m_41763_()) {
                    chalkItemStack.m_41721_(chalkItemStack.m_41773_() + 1);
                    if (chalkItemStack.m_41773_() >= chalkItemStack.m_41776_()) {
                        chalkItemStack = ItemStack.f_41583_;
                        Vec3 playerPos = player.m_20182_();
                        level.m_6263_(player, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, (SoundEvent)ModSoundEvents.CHALK_BROKEN.get(), SoundSource.PLAYERS, 0.9f, 0.9f + level.f_46441_.nextFloat() * 0.2f);
                    }
                }
                ChalkBox.setSlot(chalkBoxStack, (Integer)chalkStack.getSecond(), chalkItemStack);
                if (isGlowing) {
                    ChalkBox.useGlow(chalkBoxStack);
                }
            }
            return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack usedStack = player.m_21120_(usedHand);
        if (!usedStack.m_150930_((Item)this)) {
            return InteractionResultHolder.m_19098_((Object)usedStack);
        }
        if (player.m_36341_()) {
            this.changeSelectedChalk(usedStack);
            level.m_6263_(player, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, (SoundEvent)ModSoundEvents.CHALK_BOX_CHANGE.get(), SoundSource.PLAYERS, 0.9f, 0.9f + level.f_46441_.nextFloat() * 0.2f);
        } else {
            if (!level.f_46443_) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((containerID, playerInventory, playerEntity) -> new ChalkBoxMenu(containerID, playerInventory, usedStack, (IItemHandler)new ChalkBoxItemStackHandler(usedStack)), usedStack.m_41786_()), buffer -> buffer.m_130055_(usedStack.m_41777_()));
            }
            level.m_6263_(player, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, (SoundEvent)ModSoundEvents.CHALK_BOX_OPEN.get(), SoundSource.PLAYERS, 0.9f, 0.9f + level.f_46441_.nextFloat() * 0.2f);
        }
        return InteractionResultHolder.m_19092_((Object)usedStack, (boolean)level.f_46443_);
    }

    private void changeSelectedChalk(ItemStack usedStack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(16);
        int chalks = 0;
        for (int slot = 0; slot < 8; ++slot) {
            ItemStack slotStack = ChalkBox.getItemInSlot(usedStack, slot);
            stacks.add(slotStack);
            if (slotStack.m_41619_()) continue;
            ++chalks;
        }
        if (chalks >= 2) {
            DyeColor selectedColor = ((ChalkItem)((ItemStack)this.getFirstChalkStack(usedStack).getFirst()).m_41720_()).getColor();
            ItemStack firstStack = (ItemStack)stacks.get(0);
            for (int i = 0; i < 8; ++i) {
                ItemStack stack = (ItemStack)stacks.get(0);
                stacks.remove(stack);
                stacks.add(stack);
                stack = (ItemStack)stacks.get(0);
                if (stack.m_204117_(ModTags.Items.CHALK) && !stack.equals(firstStack, false) && !((ChalkItem)stack.m_41720_()).getColor().equals((Object)selectedColor)) break;
            }
            ChalkBox.setContents(usedStack, stacks);
        }
    }

    @Nullable
    private Pair<ItemStack, Integer> getFirstChalkStack(ItemStack chalkBoxStack) {
        for (int slot = 0; slot < 8; ++slot) {
            ItemStack itemInSlot = ChalkBox.getItemInSlot(chalkBoxStack, slot);
            if (!itemInSlot.m_204117_(ModTags.Items.CHALK)) continue;
            return Pair.of((Object)itemInSlot, (Object)slot);
        }
        return null;
    }

    public float getSelectedChalkColor(ItemStack stack) {
        if (stack.m_41782_()) {
            for (int i = 0; i < 8; ++i) {
                Item item = ChalkBox.getItemInSlot(stack, i).m_41720_();
                if (!(item instanceof ChalkItem)) continue;
                ChalkItem chalkItem = (ChalkItem)item;
                return chalkItem.getColor().m_41060_() + 1;
            }
        }
        return 0.0f;
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }
}

