/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.items;

import io.github.mortuusars.chalk.config.CommonConfig;
import io.github.mortuusars.chalk.setup.ModTags;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ChalkBox {
    public static final int SLOTS = 9;
    public static final int CHALK_SLOTS = 8;
    public static final int GLOWING_ITEM_SLOT_ID = 8;
    public static final String GLOWING_USES_TAG_KEY = "GlowUses";
    public static final String ITEMS_TAG_KEY = "Items";

    public static List<ItemStack> getContents(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag == null) {
            return Collections.emptyList();
        }
        ListTag listtag = compoundtag.m_128437_(ITEMS_TAG_KEY, 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_).toList();
    }

    public static ItemStack getItemInSlot(ItemStack chalkBoxStack, int slotID) {
        if (slotID >= 9) {
            throw new IllegalArgumentException("slotID is out if range: 0-8. Value: " + slotID);
        }
        return ItemStack.m_41712_((CompoundTag)ChalkBox.getItemsListTag(chalkBoxStack).m_128728_(slotID));
    }

    public static void setContents(ItemStack stack, List<ItemStack> items) {
        if (items.size() > 9) {
            throw new IllegalArgumentException("Items count cannot be larger than amount of slots available.");
        }
        for (int index = 0; index < Math.min(8, items.size()); ++index) {
            ChalkBox.setSlot(stack, index, items.get(index));
        }
        if (items.size() > 8) {
            ChalkBox.setSlot(stack, 8, items.get(8));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setSlot(ItemStack chalkBoxStack, int slot, ItemStack itemStack) {
        if (slot >= 0 && slot < 8) {
            if (!itemStack.m_204117_(ModTags.Items.CHALK) && !itemStack.m_41619_()) throw new IllegalArgumentException("Only '" + ModTags.Items.CHALK.f_203868_() + "' or empty ItemStack allowed in chalk slots.");
            ChalkBox.updateSlotContents(chalkBoxStack, slot, itemStack);
            return;
        } else {
            if (slot != 8) throw new IllegalArgumentException("Slot index is not in valid range - 0-8. Value: " + slot);
            if (!itemStack.m_204117_(ModTags.Items.GLOWING) && !itemStack.m_41619_()) throw new IllegalArgumentException("Only '" + ModTags.Items.GLOWING.f_203868_() + "' or empty ItemStack allowed in glowing item slot.");
            ChalkBox.updateSlotContents(chalkBoxStack, slot, itemStack);
        }
    }

    private static void updateSlotContents(ItemStack chalkBoxStack, int slot, ItemStack itemStack) {
        ListTag itemsListTag = ChalkBox.getItemsListTag(chalkBoxStack);
        itemsListTag.set(slot, (Tag)itemStack.serializeNBT());
        ChalkBox.onSlotUpdated(chalkBoxStack, slot, itemStack);
    }

    private static void onSlotUpdated(ItemStack chalkBoxStack, int slot, ItemStack itemStack) {
        if (slot == 8) {
            ChalkBox.updateGlowingUses(chalkBoxStack);
        }
    }

    @Nullable
    private static ItemStack updateSelectedChalk(ItemStack chalkBoxStack) {
        List<ItemStack> contents = ChalkBox.getContents(chalkBoxStack);
        for (ItemStack stack : contents) {
            if (!stack.m_204117_(ModTags.Items.CHALK)) continue;
            return stack;
        }
        return null;
    }

    public static int getGlowingUses(ItemStack chalkBoxStack) {
        return chalkBoxStack.m_41784_().m_128451_(GLOWING_USES_TAG_KEY);
    }

    public static void useGlow(ItemStack chalkBoxStack) {
        int glowingUses = ChalkBox.getGlowingUses(chalkBoxStack) - 1;
        chalkBoxStack.m_41784_().m_128405_(GLOWING_USES_TAG_KEY, glowingUses);
        if (glowingUses <= 0) {
            ChalkBox.updateGlowingUses(chalkBoxStack);
        }
    }

    private static void updateGlowingUses(ItemStack chalkBoxStack) {
        if (ChalkBox.getGlowingUses(chalkBoxStack) > 0) {
            return;
        }
        ItemStack glowingItemStack = ChalkBox.getContents(chalkBoxStack).get(8);
        if (!glowingItemStack.m_41619_()) {
            chalkBoxStack.m_41784_().m_128405_(GLOWING_USES_TAG_KEY, ((Integer)CommonConfig.CHALK_BOX_GLOWING_USES.get()).intValue());
            glowingItemStack.m_41774_(1);
            ChalkBox.setSlot(chalkBoxStack, 8, glowingItemStack);
        }
    }

    private static ListTag getItemsListTag(ItemStack chalkBoxStack) {
        CompoundTag compoundTag = chalkBoxStack.m_41784_();
        if (!compoundTag.m_128441_(ITEMS_TAG_KEY)) {
            ListTag itemTags = new ListTag();
            for (int index = 0; index < 9; ++index) {
                itemTags.add((Object)ItemStack.f_41583_.serializeNBT());
            }
            compoundTag.m_128365_(ITEMS_TAG_KEY, (Tag)itemTags);
        }
        return compoundTag.m_128437_(ITEMS_TAG_KEY, 10);
    }
}

