/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Vector3f;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.blocks.MarkSymbol;
import io.github.mortuusars.chalk.config.CommonConfig;
import io.github.mortuusars.chalk.setup.ModItems;
import io.github.mortuusars.chalk.setup.ModSoundEvents;
import io.github.mortuusars.chalk.setup.ModTags;
import io.github.mortuusars.chalk.utils.ParticleUtils;
import io.github.mortuusars.chalk.utils.PositionUtils;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChalkMarkBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty ORIENTATION = IntegerProperty.m_61631_((String)"orientation", (int)0, (int)8);
    public static final BooleanProperty GLOWING = BooleanProperty.m_61465_((String)"is_glowing");
    public static final EnumProperty<MarkSymbol> SYMBOL = EnumProperty.m_61587_((String)"symbol", MarkSymbol.class);
    private final DyeColor _color;
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)1.5, (double)15.5, (double)1.5, (double)14.5, (double)16.0, (double)14.5);
    private static final VoxelShape UP_AABB = Block.m_49796_((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)0.5, (double)14.5);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)1.5, (double)1.5, (double)0.0, (double)14.5, (double)14.5, (double)0.5);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)1.5, (double)1.5, (double)0.5, (double)14.5, (double)14.5);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)15.5, (double)1.5, (double)1.5, (double)16.0, (double)14.5, (double)14.5);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)1.5, (double)1.5, (double)15.5, (double)14.5, (double)14.5, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public ChalkMarkBlock(DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ORIENTATION, (Comparable)Integer.valueOf(4))).m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(false))).m_61124_(SYMBOL, (Comparable)((Object)MarkSymbol.NONE)));
        this._color = dyeColor;
        this.shapesCache = ImmutableMap.copyOf(this.m_49965_().m_61056_().stream().collect(Collectors.toMap(Function.identity(), ChalkMarkBlock::calculateShapes)));
    }

    private static VoxelShape calculateShapes(BlockState blockState) {
        return switch ((Direction)blockState.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> DOWN_AABB;
            case Direction.UP -> UP_AABB;
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
        };
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.shapesCache.get(blockState);
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState blockState) {
        return new ItemStack((ItemLike)ModItems.getChalkByColor(this._color));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (player.m_7500_()) {
            return new ItemStack((ItemLike)ModItems.getChalkByColor(this._color));
        }
        ItemStack item = this.getMatchingItemStack(player, ModItems.getChalkByColor(this._color));
        return item == ItemStack.f_41583_ ? new ItemStack((ItemLike)ModItems.getChalkByColor(this._color)) : item;
    }

    private ItemStack getMatchingItemStack(Player player, Item item) {
        return player.m_150109_().f_35974_.stream().filter(invItem -> invItem.m_41720_().getRegistryName() == item.getRegistryName()).findFirst().orElse(ItemStack.f_41583_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{ORIENTATION}).m_61104_(new Property[]{GLOWING}).m_61104_(new Property[]{SYMBOL});
    }

    public DyeColor getColor() {
        return this._color;
    }

    public VoxelShape m_5909_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.UP -> UP_AABB;
            case Direction.NORTH -> NORTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            default -> DOWN_AABB;
        };
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos pos, BlockState state, boolean p_60570_) {
        super.m_6807_(blockState, level, pos, state, p_60570_);
        if (level.f_46443_) {
            Chalk.LOGGER.info((Object)blockState);
            Chalk.LOGGER.info((Object)state);
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (((Boolean)blockState.m_61143_((Property)GLOWING)).booleanValue()) {
            return InteractionResult.PASS;
        }
        ItemStack usedItem = player.m_21120_(hand);
        if (usedItem.m_204117_(ModTags.Items.GLOWING) && world.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(true)), 11)) {
            if (!player.m_7500_()) {
                int itemsCount = usedItem.m_41613_();
                if (itemsCount-- <= 0) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                } else {
                    usedItem.m_41764_(itemsCount);
                }
            }
            world.m_5594_(null, blockPos, (SoundEvent)ModSoundEvents.MARK_GLOW_APPLIED.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
            ParticleUtils.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123810_, PositionUtils.blockCenterOffsetToFace(blockPos, (Direction)blockState.m_61143_((Property)FACING), 0.3f), new Vector3f(0.0f, 0.03f, 0.0f), 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return this.removeMark(world, pos, false);
    }

    private boolean removeMark(Level world, BlockPos pos, boolean isMoving) {
        Direction facing = (Direction)world.m_8055_(pos).m_61143_((Property)FACING);
        if (world.m_7471_(pos, isMoving)) {
            if (!world.m_5776_()) {
                world.m_5594_(null, pos, (SoundEvent)ModSoundEvents.MARK_REMOVED.get(), SoundSource.BLOCKS, 0.5f, new Random().nextFloat() * 0.2f + 0.8f);
            } else {
                ParticleUtils.spawnColorDustParticles(this._color, world, pos, facing);
            }
            return true;
        }
        return false;
    }

    public boolean m_7420_(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState blockState, Level world, BlockPos blockPos, Random random) {
        if (((Boolean)blockState.m_61143_((Property)GLOWING)).booleanValue() && random.nextInt(90) == 0) {
            ParticleUtils.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123810_, PositionUtils.blockCenterOffsetToFace(blockPos, (Direction)blockState.m_61143_((Property)FACING), 0.33f), new Vector3f(0.0f, 0.015f, 0.0f), 1);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)GLOWING) != false ? (Integer)CommonConfig.GLOWING_CHALK_MARK_LIGHT_LEVEL.get() : 0;
    }

    public void m_6256_(BlockState blockState, Level world, BlockPos pos, Player player) {
        this.removeMark(world, pos, false);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockPos relative = pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
        if (relative.equals((Object)fromPos)) {
            this.removeMark(world, pos, isMoving);
        }
    }

    public boolean m_7357_(BlockState p_196266_1_, BlockGetter blockGetter, BlockPos p_196266_3_, PathComputationType p_196266_4_) {
        return true;
    }

    public PushReaction m_5537_(BlockState p_149656_1_) {
        return PushReaction.DESTROY;
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockItemUseContext) {
        return true;
    }
}

