/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container;

import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.item.inventory.container.ContainerFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ModTileContainer<T extends AbstractModBlockEntity>
extends ModContainer {
    private final T _tile;

    public ModTileContainer(ContainerFactory factory, MenuType<? extends ModTileContainer<T>> type, int windowId, Inventory playerInventory, T tile) {
        super(factory, type, windowId, playerInventory);
        this._tile = tile;
        if (tile instanceof IConditionallySyncableEntity) {
            this.syncFrom((IConditionallySyncableEntity)tile);
        }
    }

    public ModTileContainer(ContainerFactory factory, MenuType<? extends ModTileContainer<T>> type, int windowId, T tile, ServerPlayer player) {
        this(factory, type, windowId, player.m_150109_(), tile);
        if (this._tile instanceof INetworkTileEntitySyncProvider) {
            ((INetworkTileEntitySyncProvider)this._tile).enlistForUpdates(player, true);
        }
    }

    public static <T extends AbstractModBlockEntity> ModTileContainer<T> empty(MenuType<? extends ModTileContainer<T>> type, int windowId, Inventory playerInventory, T tile) {
        return new ModTileContainer<T>(ContainerFactory.EMPTY, type, windowId, playerInventory, tile){

            public void m_182406_(int slotID, int stateId, ItemStack stack) {
            }
        };
    }

    public static <T extends AbstractModBlockEntity> ModTileContainer<T> empty(MenuType<? extends ModTileContainer<T>> type, int windowId, T tile, ServerPlayer player) {
        return new ModTileContainer<T>(ContainerFactory.EMPTY, type, windowId, tile, player){

            public void m_182406_(int slotID, int stateId, ItemStack stack) {
            }
        };
    }

    public static <T extends AbstractModBlockEntity> ModTileContainer<T> empty(MenuType<? extends ModTileContainer<T>> type, int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        return ModTileContainer.empty(type, windowId, playerInventory, AbstractModBlockEntity.getGuiClientBlockEntity(data));
    }

    public T getTileEntity() {
        return this._tile;
    }

    @Override
    public boolean m_6875_(Player player) {
        return ModTileContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)Objects.requireNonNull(this._tile.m_58904_()), (BlockPos)this._tile.m_58899_()), (Player)player, (Block)((AbstractModBlockEntity)this._tile).getBlockType());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this._tile instanceof INetworkTileEntitySyncProvider && player instanceof ServerPlayer) {
            ((INetworkTileEntitySyncProvider)this._tile).delistFromUpdates((ServerPlayer)player);
        }
    }
}

