/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import com.mojang.math.Vector4f;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Vector3i {
    public static final Vector3i ZERO = new Vector3i();
    public final int X;
    public final int Y;
    public final int Z;

    public Vector3i(int x, int y, int z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
    }

    public Vector3i(Vector3i other) {
        this(other.X, other.Y, other.Z);
    }

    public static Vector3i from(Vec3i data) {
        return new Vector3i(data.m_123341_(), data.m_123342_(), data.m_123343_());
    }

    public static Vector3i from(Vector4f data) {
        return new Vector3i((int)data.m_123601_(), (int)data.m_123615_(), (int)data.m_123616_());
    }

    public static Vector3i from(Entity data) {
        return new Vector3i((int)data.m_20185_(), (int)data.m_20186_(), (int)data.m_20189_());
    }

    public static Vector3i from(BlockEntity data) {
        return Vector3i.from((Vec3i)data.m_58899_());
    }

    public static Vector3i syncDataFrom(CompoundTag data) {
        return new Vector3i(data.m_128451_("vx"), data.m_128451_("vy"), data.m_128451_("vz"));
    }

    public CompoundTag syncDataTo(CompoundTag data) {
        data.m_128405_("vx", this.X);
        data.m_128405_("vy", this.Y);
        data.m_128405_("vz", this.Z);
        return data;
    }

    public Vec3i toVec3i() {
        return new Vec3i(this.X, this.Y, this.Z);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.X, this.Y, this.Z);
    }

    public Vector3i add(int offsetX, int offsetY, int offsetZ) {
        return new Vector3i(this.X + offsetX, this.Y + offsetY, this.Z + offsetZ);
    }

    public Vector3i add(int offset) {
        return this.add(offset, offset, offset);
    }

    public Vector3i add(Vector3d offset) {
        return this.add((int)offset.X, (int)offset.Y, (int)offset.X);
    }

    public Vector3i add(Vec3i offset) {
        return this.add(offset.m_123341_(), offset.m_123342_(), offset.m_123343_());
    }

    public Vector3i subtract(int offsetX, int offsetY, int offsetZ) {
        return new Vector3i(this.X - offsetX, this.Y - offsetY, this.Z - offsetZ);
    }

    public Vector3i subtract(int offset) {
        return this.subtract(offset, offset, offset);
    }

    public Vector3i subtract(Vector3i offset) {
        return this.subtract(offset.X, offset.Y, offset.Z);
    }

    public Vector3i multiply(int factorX, int factorY, int factorZ) {
        return new Vector3i(this.X * factorX, this.Y * factorY, this.Z * factorZ);
    }

    public Vector3i multiply(double factorX, double factorY, double factorZ) {
        return new Vector3i((int)((double)this.X * factorX), (int)((double)this.Y * factorY), (int)((double)this.Z * factorZ));
    }

    public Vector3i multiply(int factor) {
        return this.multiply(factor, factor, factor);
    }

    public Vector3i multiply(double factor) {
        return this.multiply(factor, factor, factor);
    }

    public Vector3i multiply(Vector3i factor) {
        return this.multiply(factor.X, factor.Y, factor.Z);
    }

    public Vector3i divide(int factorX, int factorY, int factorZ) {
        return new Vector3i(this.X / factorX, this.Y / factorY, this.Z / factorZ);
    }

    public Vector3i divide(double factorX, double factorY, double factorZ) {
        return new Vector3i((int)((double)this.X / factorX), (int)((double)this.Y / factorY), (int)((double)this.Z / factorZ));
    }

    public Vector3i divide(int factor) {
        return this.divide(factor, factor, factor);
    }

    public Vector3i divide(double factor) {
        return this.divide(factor, factor, factor);
    }

    public Vector3i divide(Vec3i factor) {
        return this.divide(factor.m_123341_(), factor.m_123342_(), factor.m_123343_());
    }

    public Vector3i ceil() {
        return new Vector3i(Mth.m_14167_((float)this.X), Mth.m_14167_((float)this.Y), Mth.m_14167_((float)this.Z));
    }

    public Vector3i floor() {
        return new Vector3i(Mth.m_14143_((float)this.X), Mth.m_14143_((float)this.Y), Mth.m_14143_((float)this.Z));
    }

    public Vector3i crossProduct(Vector3i vec) {
        return new Vector3i(this.Y * vec.Z - this.Z * vec.Y, this.Z * vec.X - this.X * vec.Z, this.X * vec.Y - this.Y * vec.X);
    }

    public double magnitude() {
        return Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z);
    }

    public Vector3i normalize() {
        double magnitude = this.magnitude();
        if (0.0 != magnitude) {
            return this.multiply(1.0 / magnitude);
        }
        return this;
    }

    public int scalarProduct(int x, int y, int z) {
        return this.X * x + this.Y * y + this.Z * z;
    }

    public boolean equals(Object other) {
        if (other instanceof Vector3i) {
            Vector3i v = (Vector3i)other;
            return this.X == v.X && this.Y == v.Y && this.Z == v.Z;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.X, this.Y, this.Z);
    }

    public String toString() {
        return String.format("Vector3i (%d, %d, %d)", this.X, this.Y, this.Z);
    }

    private Vector3i() {
        this.Z = 0;
        this.Y = 0;
        this.X = 0;
    }
}

