/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class Point {
    public static final Point ZERO = new Point();
    public final int X;
    public final int Y;

    public Point(int x, int y) {
        this.X = x;
        this.Y = y;
    }

    public Point(Point other) {
        this(other.X, other.Y);
    }

    public static Point syncDataFrom(CompoundTag data) {
        if (data.m_128441_("px") && data.m_128441_("py")) {
            return new Point(data.m_128451_("px"), data.m_128451_("py"));
        }
        return ZERO;
    }

    public CompoundTag syncDataTo(CompoundTag data) {
        data.m_128405_("px", this.X);
        data.m_128405_("py", this.Y);
        return data;
    }

    public Point offset(int offsetX, int offsetY) {
        return new Point(this.X + offsetX, this.Y + offsetY);
    }

    public Point offset(Point offset) {
        return new Point(this.X + offset.X, this.Y + offset.Y);
    }

    public boolean collinear(Direction.Axis axis, int n1, int n2) {
        switch (axis) {
            case X: {
                return n1 <= this.X && this.X <= n2;
            }
            case Y: {
                return n1 <= this.Y && this.Y <= n2;
            }
        }
        return false;
    }

    public boolean collinear(Point p1, Point p2) {
        return 0 == this.X * (p1.Y - p2.Y) + p1.X * (p2.Y - this.Y) + p2.X * (this.Y - p1.Y);
    }

    public boolean equals(Object other) {
        if (other instanceof Point) {
            Point p = (Point)other;
            return this.X == p.X && this.Y == p.Y;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.X, this.Y);
    }

    public String toString() {
        return String.format("Point (%d, %d)", this.X, this.Y);
    }

    private Point() {
        this.Y = 0;
        this.X = 0;
    }
}

