/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render;

import com.mojang.math.Vector3f;
import it.zerono.mods.zerocore.lib.client.render.IVertexSource;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.data.gfx.LightMap;
import it.zerono.mods.zerocore.lib.data.gfx.UV;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Vertex
implements IVertexSource {
    public final Vector3d POSITION;
    public final Vector3f NORMAL;
    public final UV UV;
    public final Colour COLOUR;
    public final LightMap LIGHT_MAP;
    public final LightMap OVERLAY_MAP;
    public int IDX;

    public Vertex(Vector3d position, Colour colour) {
        this.POSITION = position;
        this.NORMAL = null;
        this.UV = null;
        this.COLOUR = colour;
        this.LIGHT_MAP = null;
        this.OVERLAY_MAP = null;
    }

    public Vertex(Vector3d position, UV uv) {
        this.POSITION = position;
        this.NORMAL = null;
        this.UV = uv;
        this.COLOUR = null;
        this.LIGHT_MAP = null;
        this.OVERLAY_MAP = null;
    }

    public Vertex(Vector3d position, @Nullable Vector3f normal, @Nullable UV uv, @Nullable Colour colour, @Nullable LightMap lightMap, @Nullable LightMap overlayMap) {
        this.POSITION = position;
        this.NORMAL = normal;
        this.UV = uv;
        this.COLOUR = colour;
        this.LIGHT_MAP = lightMap;
        this.OVERLAY_MAP = overlayMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[%d] p:(%f, %f, %f)", this.IDX, this.POSITION.X, this.POSITION.Y, this.POSITION.Z));
        if (null != this.COLOUR) {
            sb.append(String.format(" c:(%d, %d, %d, %d)", this.COLOUR.R, this.COLOUR.G, this.COLOUR.B, this.COLOUR.A));
        }
        if (null != this.UV) {
            sb.append(String.format(" t:(%f, %f)", Float.valueOf(this.UV.U), Float.valueOf(this.UV.V)));
        }
        if (null != this.OVERLAY_MAP) {
            sb.append(String.format(" o:(%d, %d)", this.OVERLAY_MAP.U, this.OVERLAY_MAP.V));
        }
        if (null != this.LIGHT_MAP) {
            sb.append(String.format(" l:(%d, %d)", this.LIGHT_MAP.U, this.LIGHT_MAP.V));
        }
        if (null != this.NORMAL) {
            sb.append(String.format(" n:(%f, %f, %f)", Float.valueOf(this.NORMAL.m_122239_()), Float.valueOf(this.NORMAL.m_122260_()), Float.valueOf(this.NORMAL.m_122269_())));
        }
        return sb.toString();
    }

    @Override
    public Vector3d getPos() {
        return this.POSITION;
    }

    @Override
    @Nullable
    public Vector3f getNormal() {
        return this.NORMAL;
    }

    @Override
    @Nullable
    public UV getUV() {
        return this.UV;
    }

    @Override
    @Nullable
    public Colour getColour() {
        return this.COLOUR;
    }

    @Override
    @Nullable
    public LightMap getLightMap() {
        return this.LIGHT_MAP;
    }

    @Override
    @Nullable
    public LightMap getOverlayMap() {
        return this.OVERLAY_MAP;
    }
}

