/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.network;

import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.InternalCommand;
import it.zerono.mods.zerocore.internal.network.ContainerDataMessage;
import it.zerono.mods.zerocore.internal.network.ErrorReportMessage;
import it.zerono.mods.zerocore.internal.network.InternalCommandMessage;
import it.zerono.mods.zerocore.internal.network.TileCommandMessage;
import it.zerono.mods.zerocore.lib.data.nbt.NBTBuilder;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.network.IModMessage;
import it.zerono.mods.zerocore.lib.network.ModSyncableTileMessage;
import it.zerono.mods.zerocore.lib.network.NetworkHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class Network {
    public static final NetworkHandler HANDLER = new NetworkHandler(ZeroCore.newID("network"), "1");

    public static void initialize() {
        HANDLER.registerMessage(TileCommandMessage.class, TileCommandMessage::new);
        HANDLER.registerMessage(ModSyncableTileMessage.class, ModSyncableTileMessage::new);
        HANDLER.registerMessage(ErrorReportMessage.class, ErrorReportMessage::new);
        HANDLER.registerMessage(InternalCommandMessage.class, InternalCommandMessage::new);
        HANDLER.registerMessage(ContainerDataMessage.class, ContainerDataMessage::new);
    }

    public static <Message extends IModMessage> void sendToAllPlayers(Message message) {
        if (null != ServerLifecycleHooks.getCurrentServer()) {
            HANDLER.sendToAllPlayers(message);
        }
    }

    public static void sendClearRecipeCommand() {
        Network.sendToAllPlayers(new InternalCommandMessage(InternalCommand.ClearRecipes));
    }

    public static void sendDebugGuiFrameCommand(boolean enable) {
        Network.sendToAllPlayers(new InternalCommandMessage(InternalCommand.DebugGuiFrame, new NBTBuilder().addBoolean("enable", enable).build()));
    }

    public static void sendServerContainerDataSync(ServerPlayer player, CompoundTag data) {
        HANDLER.sendToPlayer(new InternalCommandMessage(InternalCommand.ContainerDataSync, data), player);
    }

    public static void sendServerContainerData(ServerPlayer player, ModContainer container) {
        HANDLER.sendToPlayer(new ContainerDataMessage(container), player);
    }
}

