/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.redstone.sensor;

import com.google.common.collect.ImmutableList;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorType;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.functional.NonNullToIntFunction;
import java.util.List;

public final class SensorTypeData<Reader extends IMachineReader>
implements ISensorType<Reader> {
    private final IoDirection _direction;
    private final List<SensorBehavior> _validBehaviors;
    private final NonNullToIntFunction<Reader> _outputTestSupplier;

    public static <Reader extends IMachineReader> SensorTypeData<Reader> input(SensorBehavior ... behaviors) {
        return new SensorTypeData<IMachineReader>(IoDirection.Input, SensorTypeData::inputSensorTest, behaviors);
    }

    public static <Reader extends IMachineReader> SensorTypeData<Reader> output(NonNullToIntFunction<Reader> outputSupplier, SensorBehavior ... behaviors) {
        return new SensorTypeData<Reader>(IoDirection.Output, outputSupplier, behaviors);
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public boolean isInput() {
        return this._direction.isInput();
    }

    @Override
    public boolean isOutput() {
        return this._direction.isOutput();
    }

    @Override
    public List<SensorBehavior> getBehaviors() {
        return this._validBehaviors;
    }

    @Override
    public int applyAsInt(Reader reader) {
        return this._outputTestSupplier.applyAsInt(reader);
    }

    @Override
    public String getTranslationBaseName() {
        return "";
    }

    private SensorTypeData(IoDirection direction, NonNullToIntFunction<Reader> outputSupplier, SensorBehavior ... behaviors) {
        this._direction = direction;
        this._outputTestSupplier = outputSupplier;
        this._validBehaviors = ImmutableList.copyOf((Object[])behaviors);
    }

    private static <Reader extends IMachineReader> int inputSensorTest(Reader reader) {
        return 0;
    }
}

