/*
 * Decompiled with CFR 0.152.
 */
package com.eternalsage.rainplants.network;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ParticleSpawnPacket {
    protected double dx;
    protected double dy;
    protected double dz;

    public ParticleSpawnPacket(double cx, double cy, double cz) {
        this.dx = cx;
        this.dy = cy;
        this.dz = cz;
    }

    public static void encode(ParticleSpawnPacket packet, FriendlyByteBuf buffer) {
        buffer.writeDouble(packet.dx);
        buffer.writeDouble(packet.dy);
        buffer.writeDouble(packet.dz);
    }

    public static ParticleSpawnPacket decode(FriendlyByteBuf buf) {
        return new ParticleSpawnPacket(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(ParticleSpawnPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ParticleSpawnPacket.processMessage(message));
        context.setPacketHandled(true);
    }

    static void processMessage(ParticleSpawnPacket message) {
        double[] x = new double[]{0.0, 0.067, 0.25, 0.5, 0.75, 0.933, 1.0, 0.933, 0.75, 0.5, 0.25, 0.067, 0.0, 0.067, 0.25, 0.5, 0.75, 0.933, 1.0, 0.933, 0.75, 0.5, 0.25, 0.067, 0.0, 0.067, 0.25, 0.5, 0.75, 0.933, 1.0, 0.933, 0.75, 0.5, 0.25, 0.067, 0.0, 0.067, 0.25, 0.5, 0.75, 0.933, 1.0, 0.933, 0.75, 0.5, 0.25, 0.067, 0.0};
        double[] z = new double[]{0.5, 0.25, 0.067, 0.0, 0.067, 0.25, 0.5, 0.75, 0.933, 1.0, 0.933, 0.75, 0.5, 0.25, 0.067, 0.0, 0.067, 0.25, 0.5, 0.75, 0.933, 1.0, 0.933, 0.75, 0.5, 0.25, 0.067, 0.0, 0.067, 0.25, 0.5, 0.75, 0.933, 1.0, 0.933, 0.75, 0.5, 0.25, 0.067, 0.0, 0.067, 0.25, 0.5, 0.75, 0.933, 1.0, 0.933, 0.75, 0.5};
        Random rand = new Random();
        int offset = rand.nextInt(16);
        for (int i = 0; i != 16; ++i) {
            Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, message.dx + x[i + offset], message.dy + 0.5 + (double)i * 0.05, message.dz + z[i + offset], 0.0, 2.0, 0.0);
        }
    }
}

