/*
 * Decompiled with CFR 0.152.
 */
package com.eternalsage.rainplants.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    public static int PLANTPLUSCHANCE = 0;
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public ForgeConfigSpec.IntValue skipGrowthChance;
        public ForgeConfigSpec.BooleanValue canRainBeBlocked;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.skipGrowthChance = builder.comment("1 out of X chance for crop to skip a growth stage").defineInRange("skipGrowthChance", 4, 0, 100);
            this.canRainBeBlocked = builder.comment("If true, rain has to touch crop for it to grow faster.").define("canRainBeBlocked", true);
            builder.pop();
        }
    }

    public static class Helper {
        private static final FileConfig CONFIG_FILE = FileConfig.of((File)new File(FMLPaths.CONFIGDIR.get().toFile(), "aquaculture-common.toml"));

        public static <T> T get(String category, String subCategory, String value) {
            return Helper.get(category + "." + subCategory, value);
        }

        public static <T> T get(String category, String value) {
            CONFIG_FILE.load();
            return (T)CONFIG_FILE.get(category + "." + value);
        }

        public static String getSubConfig(String category, String subCategory) {
            return category + "." + subCategory;
        }
    }
}

