/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class GasRenderer
extends EntityRenderer<GasEntity> {
    public GasRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
    }

    public ResourceLocation getTextureLocation(GasEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public void render(GasEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Level level = entity.f_19853_;
        BlockState carriedGas = entity.getCarriedBlockState().orElse(null);
        if (carriedGas == null) {
            return;
        }
        if (carriedGas.m_60799_() != RenderShape.MODEL) {
            return;
        }
        float scale = 0.99f;
        float offset = 0.004999995f;
        for (double y : new double[]{entity.m_142469_().f_82289_ + 0.004999995231628418, entity.m_142469_().f_82292_ - 0.004999995231628418}) {
            BlockPos pos = new BlockPos(entity.m_20185_(), y, entity.m_20189_());
            if (!GameWorld.SmokeContainers.isFullHeightNarrowChimney((LevelReader)level, (BlockPos)pos)) continue;
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)-0.495f, 0.004999995231628418, (double)-0.495f);
        poseStack.m_85841_(0.99f, 0.99f, 0.99f);
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        RenderType renderType = RenderType.m_110469_();
        BlockPos blockPos = entity.m_142538_();
        ForgeHooksClient.setRenderType((RenderType)renderType);
        dispatcher.m_110937_().m_111047_((BlockAndTintGetter)level, dispatcher.m_110910_(carriedGas), carriedGas, blockPos, poseStack, buffer.m_6299_(renderType), false, new Random(), carriedGas.m_60726_(blockPos), OverlayTexture.f_118083_);
        ForgeHooksClient.setRenderType(null);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

