/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.emissions;

import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.emissions.AbstractEntityEmission;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.INBTSerializable;

public class PeriodicEntityEmission
extends AbstractEntityEmission<Entity, Emitter> {
    public static float rate = 1.0f;

    protected PeriodicEntityEmission(Entity entity, Emitter emitter, GameTime updateInterval) {
        super(entity, emitter, updateInterval);
    }

    public static PeriodicEntityEmission of(Entity entity, Emitter emitter) {
        return new PeriodicEntityEmission(entity, emitter, GameTime.second());
    }

    public boolean isEntityDeadOrRemoved() {
        Entity entity = (Entity)this.getEntity();
        if (!entity.m_6084_()) {
            return true;
        }
        return !entity.isAddedToWorld();
    }

    @Override
    public BlockPos getEntityBlockPos() {
        return ((Entity)this.getEntity()).m_142538_();
    }

    public void onUpdate() {
        if (this.isEntityDeadOrRemoved()) {
            this.kill();
            return;
        }
        if (this.isInEntityTickingChunk()) {
            Level level = this.getWorldLevel();
            Emitter emitter = (Emitter)((Object)this.getEmitter());
            if (emitter.isActive((INBTSerializable<CompoundTag>)((INBTSerializable)this.getEntity()))) {
                float factor = 1.0f;
                if (!emitter.hasSeparateRateControl()) {
                    factor *= rate;
                }
                BlockPos pos = emitter.getExhaustPosition((LevelAccessor)level, (INBTSerializable<CompoundTag>)((INBTSerializable)this.getEntity()), this.getEntityBlockPos());
                emitter.emitAt(level, pos, factor);
            }
        }
    }

    @Nullable
    public Level getWorldLevel() {
        return ((Entity)this.getEntity()).f_19853_;
    }
}

