/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.ModList;

public class CreateTFMG {
    public static final String MOD_ID = "createindustry";

    public static Emitter.Properties<?> flarestack() {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile(BlockStateProperties.f_61443_).id(UnitId.from((String)MOD_ID, (String)"flarestack").withMetaAll()).carbon(1.0f))).sulfur(0.1f));
    }

    public static class Engine
    extends Emitter {
        private Class<?> pumpClass = null;
        private Class<?> pipeClass = null;
        private Class<?> exhaustClass = null;
        protected final int maxExhaustPipeLength;

        public static Emitter.Properties<?> properties(String engineType) {
            UnitId engineId = UnitId.from((String)CreateTFMG.MOD_ID, (String)engineType).withNameSuffix("engine").withMetaAll();
            return ((Emitter.Properties)((Object)Emitter.Properties.fuel("").id(engineId).customFactory(Engine::new))).relatedBlocks(engineId.withNameSuffix("back").toString());
        }

        public Engine(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
            this.maxExhaustPipeLength = UnitConfig.getInt((UnitConfig)config, (String)this.getClassCategory(), (String)"maxExhaustPipeLength", (int)128, (IntBounds)IntBounds.between((Integer)1, (Integer)1024), (String)"The maximum length of the exhaust pipe.\nNote that high values affect performance");
            if (ModList.get().isLoaded(CreateTFMG.MOD_ID)) {
                try {
                    this.pumpClass = Class.forName("com.simibubi.create.content.fluids.pump.PumpBlockEntity");
                    this.pipeClass = Class.forName("com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity");
                    this.exhaustClass = Class.forName("com.drmangotea.createindustry.blocks.machines.exhaust.ExhaustBlockEntity");
                }
                catch (Exception e) {
                    ForgeEndertech.getInstance().getLogger().error(e.toString());
                }
            }
        }

        protected boolean hasBackPart(LevelAccessor level, BlockPos frontPartPos, Direction facingDirection) {
            if (!this.getRelatedBlocks().isEmpty()) {
                BlockPos pos = frontPartPos.m_142300_(facingDirection.m_122424_());
                BlockState state = level.m_8055_(pos);
                return this.getRelatedBlocks().contains(state) && this.isFacing(facingDirection, state);
            }
            return false;
        }

        @Override
        public BlockPos getExhaustPosition(LevelAccessor level, INBTSerializable<CompoundTag> nbtSource, BlockPos defaultPos) {
            Direction facingDirection = this.getFacingDirection(level.m_8055_(defaultPos)).orElse(null);
            if (facingDirection == null) {
                return defaultPos;
            }
            boolean hasBackPart = this.hasBackPart(level, defaultPos, facingDirection);
            BlockPos startPos = hasBackPart ? defaultPos.m_142300_(facingDirection.m_122424_()) : defaultPos;
            List directions = hasBackPart ? Collections.singletonList(facingDirection.m_122424_()) : GameWorld.Directions.of().all().shuffle().toList();
            for (Direction direction : directions) {
                Optional<BlockPos> outlet;
                BlockPos pos = startPos.m_142300_(direction);
                BlockState state = level.m_8055_(pos);
                if ((!this.isActivePump(level, pos) || !this.isFacing(direction, state)) && (!this.isPipe(level, pos) || !this.isConnectedTo(direction, state)) || !(outlet = this.getPipeOutlet(level, pos)).isPresent()) continue;
                return outlet.get();
            }
            return defaultPos;
        }

        protected boolean isActivePump(LevelAccessor level, BlockPos pos) {
            BlockEntity tile = level.m_7702_(pos);
            if (this.pumpClass != null && this.pumpClass.isInstance(tile)) {
                CompoundTag compound = TagHelper.serialize((INBTSerializable)tile);
                float speed = compound.m_128457_("Speed");
                return speed != 0.0f;
            }
            return false;
        }

        protected boolean isPipe(LevelAccessor level, BlockPos pos) {
            return this.pipeClass != null && this.pipeClass.isInstance(level.m_7702_(pos));
        }

        protected boolean isExhaust(LevelAccessor level, BlockPos pos) {
            return this.exhaustClass != null && this.exhaustClass.isInstance(level.m_7702_(pos));
        }

        protected boolean isFacing(Direction direction, BlockState state) {
            return this.stateHasValue(state, "facing", direction.m_122433_());
        }

        protected boolean isConnectedTo(Direction face, BlockState state) {
            return this.stateHasValue(state, face.m_122424_().m_122433_(), "true");
        }

        protected Optional<Direction> getFacingDirection(BlockState state) {
            for (Direction direction : GameWorld.Directions.of().horizontals().toArray()) {
                if (!this.isFacing(direction, state)) continue;
                return Optional.of(direction);
            }
            return Optional.empty();
        }

        protected boolean stateHasValue(BlockState state, String propertyName, String valueName) {
            Property property = state.m_60734_().m_49965_().m_61081_(propertyName);
            if (property != null && state.m_61138_(property)) {
                return property.m_6215_(valueName).filter(value -> value.equals(state.m_61143_(property))).isPresent();
            }
            return false;
        }

        protected Optional<BlockPos> getPipeOutlet(final LevelAccessor level, BlockPos startPos) {
            WorldSearch.BlockChain pipe = new WorldSearch.BlockChain(level, startPos, this.maxExhaustPipeLength){

                protected Collection<Direction> getDirections() {
                    return GameWorld.Directions.of().all().shuffle().toList();
                }

                private boolean isValidDirection(BlockPos pos) {
                    if (this.lastUsedDirection != null) {
                        BlockPos prevPos = pos.m_142300_(this.lastUsedDirection.m_122424_());
                        BlockState state = level.m_8055_(prevPos);
                        return this.isConnectedTo(this.lastUsedDirection.m_122424_(), state) || this.isFacing(this.lastUsedDirection, state);
                    }
                    return false;
                }

                protected boolean isValidPath(BlockPos pos) {
                    if (this.lastUsedDirection == null) {
                        return true;
                    }
                    if (this.isValidDirection(pos)) {
                        BlockState state = level.m_8055_(pos);
                        if (this.isPipe(level, pos) && this.isConnectedTo(this.lastUsedDirection, state)) {
                            return true;
                        }
                        if (this.isActivePump(level, pos) && this.isFacing(this.lastUsedDirection, state)) {
                            return true;
                        }
                    }
                    return false;
                }

                protected boolean isValidBlock(BlockPos pos) {
                    if (this.isValidDirection(pos)) {
                        BlockState state = level.m_8055_(pos);
                        if (state.m_60795_()) {
                            return true;
                        }
                        if (this.isExhaust(level, pos) && (this.isFacing(this.lastUsedDirection, state) || this.isFacing(this.lastUsedDirection.m_122424_(), state))) {
                            return true;
                        }
                    }
                    return false;
                }

                protected boolean onValidFound(BlockPos pos) {
                    return true;
                }
            };
            pipe.build();
            return pipe.getFound().stream().findFirst();
        }

        protected void debuglog(String msg) {
            ForgeEndertech.debugMsg((String)msg);
        }
    }
}

