/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.AbstractRocket;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;

public class BeyondEarth {

    public static class Rocket
    extends AbstractRocket {
        public static Emitter.Properties<?> properties(int tier) {
            return ((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.entity("rocket_start", WorldEvents.Alignment.BOTTOM).carbon(250.0f * (float)tier))).sulfur(25.0f * (float)tier))).customFactory(Rocket::new);
        }

        public Rocket(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        public int getMaxRadius() {
            return 3;
        }

        @Override
        public int getMaxEmitPositions() {
            return CommonMath.Random.between((int)1, (int)this.getMaxRadius());
        }

        @Override
        protected float getRate() {
            return 1.0f;
        }
    }

    public static class Rover
    extends Emitter {
        public static Emitter.Properties<?> properties() {
            return ((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.entity("fuel", WorldEvents.Alignment.BACK).carbon(4.0f))).sulfur(0.4f))).customFactory(Rover::new);
        }

        public Rover(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isActive(INBTSerializable<CompoundTag> nbtSource) {
            if (!(nbtSource instanceof Entity)) return false;
            Entity entity = (Entity)nbtSource;
            if (Optional.ofNullable(entity.m_146895_()).filter(Player.class::isInstance).map(Player.class::cast).map(player -> (double)Math.abs(player.f_20902_) > 0.01).orElse(false) == false) return false;
            boolean bl = true;
            boolean isMoving = bl;
            if (!isMoving) return false;
            if (!super.isActive(nbtSource)) return false;
            return true;
        }
    }
}

