/*
 * Decompiled with CFR 0.152.
 */
package commoble.looot.util;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;

public class RandomHelper {
    @Nullable
    public static <T> T getRandomThingFrom(Random rand, List<T> things) {
        int size = things.size();
        return size > 0 ? (T)things.get(rand.nextInt(size)) : null;
    }

    @SafeVarargs
    @Nullable
    public static <T> T chooseRandomThing(Random rand, T ... things) {
        int size = things.length;
        return size > 0 ? (T)things[rand.nextInt(things.length)] : null;
    }

    public static <T> Optional<T> getRandomThingFromMultipleLists(Random rand, List<? extends List<T>> lists) {
        int totalSize = lists.stream().reduce(0, (size, list) -> size + list.size(), (sizeA, sizeB) -> sizeA + sizeB);
        if (totalSize > 0) {
            int index = rand.nextInt(totalSize);
            for (List<T> list2 : lists) {
                int sizeOfThisList = list2.size();
                if (index < sizeOfThisList) {
                    return Optional.of(list2.get(index));
                }
                index -= sizeOfThisList;
            }
        }
        return Optional.empty();
    }
}

