/*
 * Decompiled with CFR 0.152.
 */
package commoble.looot.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import commoble.looot.Looot;
import commoble.looot.util.RandomHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.tuple.Pair;

public class NameEnchantedItem
extends LootItemConditionalFunction {
    public static final ResourceLocation ID = new ResourceLocation("looot", "name_enchanted_item");
    public static final LootItemFunctionType TYPE = new LootItemFunctionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    public static final ResourceLocation ALL = new ResourceLocation("looot", "all");
    public static final ResourceLocation UNKNOWN_ENCHANTMENT = new ResourceLocation("looot", "unknown_enchantment");
    public static final TranslatableComponent VERY_UNKNOWN_ENCHANTMENT_PREFIX = new TranslatableComponent("looot.unknown_enchantment.prefix");
    public static final TranslatableComponent VERY_UNKNOWN_ENCHANTMENT_SUFFIX = new TranslatableComponent("looot.unknown_enchantment.suffix");
    public static final TranslatableComponent UNKNOWN_DESCRIPTOR = new TranslatableComponent("looot.unknown_descriptor");
    public static final Style DEFAULT_MINOR_STYLE = Style.f_131099_.m_131157_(ChatFormatting.AQUA).m_131155_(Boolean.valueOf(false));
    public static final Style DEFAULT_MAJOR_STYLE = Style.f_131099_.m_131157_(ChatFormatting.LIGHT_PURPLE).m_131155_(Boolean.valueOf(false));
    protected final boolean ignoreEnchantments;
    protected final Optional<Style> minorStyle;
    protected final Optional<Style> majorStyle;

    public NameEnchantedItem(LootItemCondition[] conditionsIn, Optional<Style> minorStyle, Optional<Style> majorStyle, boolean ignoreEnchantments) {
        super(conditionsIn);
        this.minorStyle = minorStyle;
        this.majorStyle = majorStyle;
        this.ignoreEnchantments = ignoreEnchantments;
    }

    public LootItemFunctionType m_7162_() {
        return TYPE;
    }

    public static MutableComponent getNameForEnchantment(boolean isPrefix, Enchantment enchantment, int level, Random rand) {
        List<MutableComponent> names;
        int maxKnownLevel = Looot.INSTANCE.enchantmentNameLimits.limits.getOrDefault((Object)enchantment, 0);
        int highestNameableLevel = Math.min(maxKnownLevel, level);
        if (highestNameableLevel > 0) {
            String position = isPrefix ? ".prefix." : ".suffix.";
            return new TranslatableComponent(enchantment.m_44704_() + position + level);
        }
        List<MutableComponent> list = names = isPrefix ? Looot.INSTANCE.epicNamePrefixes.translationKeys.get(ALL) : Looot.INSTANCE.epicNameSuffixes.translationKeys.get(UNKNOWN_ENCHANTMENT);
        if (names.size() > 0) {
            return RandomHelper.getRandomThingFrom(rand, names);
        }
        return isPrefix ? VERY_UNKNOWN_ENCHANTMENT_PREFIX : VERY_UNKNOWN_ENCHANTMENT_SUFFIX;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        BinaryOperator biggestReducer = (a, b) -> (Integer)b.getValue() > (Integer)a.getValue() ? b : a;
        Random rand = context.m_78933_();
        int enchantmentCount = enchantments.size();
        if (this.ignoreEnchantments || enchantmentCount > 2) {
            stack.m_41714_((Component)NameEnchantedItem.getEpicName(stack, context).m_130948_(this.majorStyle.orElse(DEFAULT_MAJOR_STYLE)));
        } else if (enchantmentCount > 0) {
            Optional biggest = enchantments.entrySet().stream().reduce(biggestReducer);
            Optional<Map.Entry> secondBiggest = enchantments.entrySet().stream().filter(entry -> entry != biggest.get()).reduce(biggestReducer);
            Pair twoBiggest = context.m_78933_().nextBoolean() ? Pair.of(biggest, secondBiggest) : Pair.of(secondBiggest, biggest);
            Optional<MutableComponent> maybePrefix = ((Optional)twoBiggest.getLeft()).map(entry -> NameEnchantedItem.getNameForEnchantment(true, (Enchantment)entry.getKey(), (Integer)entry.getValue(), rand));
            Optional<MutableComponent> maybeSuffix = ((Optional)twoBiggest.getRight()).map(entry -> NameEnchantedItem.getNameForEnchantment(false, (Enchantment)entry.getKey(), (Integer)entry.getValue(), rand));
            Component stackText = stack.m_41786_();
            if (stackText instanceof MutableComponent) {
                MutableComponent formattableStackText = (MutableComponent)stackText;
                MutableComponent prefixedStackText = maybePrefix.map(prefix -> prefix.m_130946_(" ").m_7220_((Component)formattableStackText)).orElse(formattableStackText);
                MutableComponent suffixedStackText = maybeSuffix.map(suffix -> prefixedStackText.m_130946_(" ").m_7220_((Component)suffix)).orElse(prefixedStackText);
                stack.m_41714_((Component)suffixedStackText.m_130948_(this.minorStyle.orElse(DEFAULT_MINOR_STYLE)));
            }
        }
        return stack;
    }

    public static MutableComponent getEpicName(ItemStack stack, LootContext context) {
        Random random = context.m_78933_();
        Pair<MutableComponent, MutableComponent> words = NameEnchantedItem.getRandomWords(stack, random);
        return ((MutableComponent)words.getLeft()).m_6881_().m_7220_((Component)new TextComponent(" ")).m_7220_((Component)((MutableComponent)words.getRight()).m_6881_());
    }

    public static Pair<MutableComponent, MutableComponent> getRandomWords(ItemStack stack, Random rand) {
        int indices = rand.nextInt(4);
        int first = indices / 2;
        int second = indices % 2 + 1;
        List lists = Looot.INSTANCE.wordMaps.stream().map(map -> map.translationKeys.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).equals((Object)ALL) || stack.m_204117_(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)((ResourceLocation)entry.getKey())))).map(Map.Entry::getValue).collect(Collectors.toCollection(ArrayList::new))).collect(Collectors.toCollection(ArrayList::new));
        IntFunction<MutableComponent> getter = i -> (MutableComponent)RandomHelper.getRandomThingFromMultipleLists(rand, (List)lists.get(i)).orElse(UNKNOWN_DESCRIPTOR);
        return Pair.of((Object)getter.apply(first), (Object)getter.apply(second));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<NameEnchantedItem> {
        public static final Style.Serializer STYLE_SERIALIZER = new Style.Serializer();

        public NameEnchantedItem deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            JsonElement minorStyleElement = object.get("minor_style");
            JsonElement majorStyleElement = object.get("major_style");
            Function<JsonElement, Style> styleDeserializer = element -> STYLE_SERIALIZER.deserialize(element, Style.class, deserializationContext);
            Optional<Style> minorStyle = Optional.ofNullable(minorStyleElement).map(styleDeserializer);
            Optional<Style> majorStyle = Optional.ofNullable(majorStyleElement).map(styleDeserializer);
            boolean ignoreEnchantments = GsonHelper.m_13855_((JsonObject)object, (String)"ignore_enchantments", (boolean)false);
            return new NameEnchantedItem(conditionsIn, minorStyle, majorStyle, ignoreEnchantments);
        }

        public void serialize(JsonObject jsonObject, NameEnchantedItem lootFunction, JsonSerializationContext serializer) {
            super.m_6170_(jsonObject, (LootItemConditionalFunction)lootFunction, serializer);
            lootFunction.minorStyle.ifPresent(style -> jsonObject.add("minor_style", STYLE_SERIALIZER.serialize(style, Style.class, serializer)));
            lootFunction.majorStyle.ifPresent(style -> jsonObject.add("major_style", STYLE_SERIALIZER.serialize(style, Style.class, serializer)));
            if (lootFunction.ignoreEnchantments) {
                jsonObject.addProperty("ignore_enchantments", Boolean.valueOf(true));
            }
        }
    }
}

