/*
 * Decompiled with CFR 0.152.
 */
package commoble.looot.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.util.function.BiFunction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.ArrayUtils;

public class ApplyFunctionsIfTagged
extends LootItemConditionalFunction {
    public static final ResourceLocation ID = new ResourceLocation("looot", "apply_functions_if_tagged");
    public static final String TAG_KEY = "tag";
    public static final String FUNCTIONS_KEY = "functions";
    public static final LootItemFunctionType TYPE = new LootItemFunctionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    private final TagKey<Item> tag;
    private final LootItemFunction[] subFunctions;

    public ApplyFunctionsIfTagged(LootItemCondition[] conditions, ResourceLocation tagName, LootItemFunction[] subFunctions) {
        super(conditions);
        this.tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)tagName);
        this.subFunctions = subFunctions;
    }

    public LootItemFunctionType m_7162_() {
        return TYPE;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        ItemStack newStack = stack;
        if (stack.m_204117_(this.tag)) {
            newStack = (ItemStack)LootItemFunctions.m_80770_((BiFunction[])this.subFunctions).apply(newStack, context);
        }
        return newStack;
    }

    public static LootItemConditionalFunction.Builder<?> getBuilder(ResourceLocation tag, LootItemFunction ... subFunctions) {
        return ApplyFunctionsIfTagged.m_80683_(conditions -> new ApplyFunctionsIfTagged((LootItemCondition[])conditions, tag, subFunctions));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<ApplyFunctionsIfTagged> {
        public void serialize(JsonObject baseObject, ApplyFunctionsIfTagged applicator, JsonSerializationContext serializationContext) {
            super.m_6170_(baseObject, (LootItemConditionalFunction)applicator, serializationContext);
            if (applicator.subFunctions.length > 0) {
                baseObject.add(ApplyFunctionsIfTagged.TAG_KEY, (JsonElement)new JsonPrimitive(applicator.tag.toString()));
                if (!ArrayUtils.isEmpty((Object[])applicator.subFunctions)) {
                    baseObject.add(ApplyFunctionsIfTagged.FUNCTIONS_KEY, serializationContext.serialize((Object)applicator.subFunctions));
                }
            }
        }

        public ApplyFunctionsIfTagged deserialize(JsonObject baseObject, JsonDeserializationContext deserializationContext, LootItemCondition[] conditions) {
            ResourceLocation tagRL = new ResourceLocation(GsonHelper.m_13906_((JsonObject)baseObject, (String)ApplyFunctionsIfTagged.TAG_KEY));
            LootItemFunction[] subFunctions = (LootItemFunction[])GsonHelper.m_13845_((JsonObject)baseObject, (String)ApplyFunctionsIfTagged.FUNCTIONS_KEY, (Object)new LootItemFunction[0], (JsonDeserializationContext)deserializationContext, LootItemFunction[].class);
            return new ApplyFunctionsIfTagged(conditions, tagRL, subFunctions);
        }
    }
}

