/*
 * Decompiled with CFR 0.152.
 */
package commoble.looot.data;

import commoble.looot.data.MergeableCodecDataManager;
import commoble.looot.data.NameList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;

public class NameListManager
extends MergeableCodecDataManager<NameList, List<String>> {
    public Map<ResourceLocation, List<MutableComponent>> translationKeys = new HashMap<ResourceLocation, List<MutableComponent>>();

    public NameListManager(String folderName, Logger logger) {
        super(folderName, logger, NameList.CODEC, NameList::merge);
    }

    @Override
    protected void apply(Map<ResourceLocation, List<String>> processedData, ResourceManager resourceManager, ProfilerFiller profiler) {
        super.apply(processedData, resourceManager, profiler);
        this.translationKeys = this.bakeTranslationKeys();
    }

    protected Map<ResourceLocation, List<MutableComponent>> bakeTranslationKeys() {
        HashMap<ResourceLocation, List<MutableComponent>> output = new HashMap<ResourceLocation, List<MutableComponent>>();
        this.data.forEach((id, words) -> {
            String modid = id.m_135827_();
            String path = id.m_135815_();
            String header = String.join((CharSequence)".", modid, this.folderName, path).replace("/", ".");
            List keyList = words.stream().map(s -> new TranslatableComponent(header + "." + s)).collect(Collectors.toList());
            output.put((ResourceLocation)id, keyList);
        });
        return output;
    }
}

