/*
 * Decompiled with CFR 0.152.
 */
package commoble.looot.data;

import commoble.looot.data.EnchantmentNameLimits;
import commoble.looot.data.MergeableCodecDataManager;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnchantmentNameLimitManager
extends MergeableCodecDataManager<EnchantmentNameLimits, Map<Enchantment, Integer>> {
    public static final String FOLDER_NAME = "looot/enchantment_name_limits";
    static final Logger LOGGER = LogManager.getLogger();
    @Nonnull
    public Object2IntOpenHashMap<Enchantment> limits = new Object2IntOpenHashMap();

    public EnchantmentNameLimitManager() {
        super(FOLDER_NAME, LOGGER, EnchantmentNameLimits.CODEC, EnchantmentNameLimitManager::mergeData);
    }

    @Override
    protected void apply(Map<ResourceLocation, Map<Enchantment, Integer>> processedData, ResourceManager resourceManager, ProfilerFiller profiler) {
        super.apply(processedData, resourceManager, profiler);
        this.limits = EnchantmentNameLimitManager.combineMergedData(processedData);
    }

    static Map<Enchantment, Integer> mergeData(List<EnchantmentNameLimits> raws) {
        Map<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        for (EnchantmentNameLimits raw : raws) {
            Map<Enchantment, Integer> rawMap = raw.getValues();
            if (raw.getReplace()) {
                map = rawMap;
                continue;
            }
            EnchantmentNameLimitManager.mergeSubMapIntoFinalMap(map, rawMap);
        }
        return map;
    }

    static Object2IntOpenHashMap<Enchantment> combineMergedData(Map<ResourceLocation, Map<Enchantment, Integer>> processedData) {
        Object2IntOpenHashMap data = new Object2IntOpenHashMap();
        processedData.values().forEach(subMap -> EnchantmentNameLimitManager.mergeSubMapIntoFinalMap((Map<Enchantment, Integer>)data, subMap));
        return data;
    }

    static void mergeSubMapIntoFinalMap(Map<Enchantment, Integer> data, Map<Enchantment, Integer> subMap) {
        subMap.forEach((key, value) -> data.merge((Enchantment)key, (Integer)value, Math::max));
    }
}

