/*
 * Decompiled with CFR 0.152.
 */
package commoble.looot.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DataCodecs {
    public static final Codec<Enchantment> ENCHANTMENT = DataCodecs.makeRegistryEntryCodec(ForgeRegistries.ENCHANTMENTS);

    public static final <T extends IForgeRegistryEntry<T>> Codec<T> makeRegistryEntryCodec(IForgeRegistry<T> registry) {
        return ResourceLocation.f_135803_.flatXmap(id -> DataCodecs.getRegistryObjectOrError(registry, id), obj -> DataResult.success((Object)obj.getRegistryName()));
    }

    static <T extends IForgeRegistryEntry<T>> DataResult<T> getRegistryObjectOrError(IForgeRegistry<T> registry, ResourceLocation id) {
        if (registry.containsKey(id)) {
            return DataResult.success((Object)registry.getValue(id));
        }
        return DataResult.error((String)String.format("Failed to decode registry object: no %s registered for id %s", registry.getRegistryName().toString(), id.toString()));
    }
}

