/*
 * Decompiled with CFR 0.152.
 */
package wolforce.utils;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class Util {
    public static ResourceLocation res(String domainAndPath) {
        return new ResourceLocation(domainAndPath);
    }

    public static ResourceLocation res(String modid, String path) {
        return new ResourceLocation(modid, path);
    }

    public static TextComponent[] stringsToComponents(String[] value) {
        return (TextComponent[])Arrays.stream(value).map(x -> new TextComponent(x)).toArray();
    }

    public static VoxelShape voxelShape(double x1, double y1, double z1, double x2, double y2, double z2) {
        try {
            Constructor ctor = ArrayVoxelShape.class.getConstructor(DiscreteVoxelShape.class, DoubleList.class, DoubleList.class, DoubleList.class);
            ctor.setAccessible(true);
            return (VoxelShape)ctor.newInstance(new BitSetDiscreteVoxelShape(0, 0, 0), new DoubleArrayList(new double[]{0.0}), new DoubleArrayList(new double[]{0.0}), new DoubleArrayList(new double[]{0.0}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ItemLike randomDye() {
        switch ((int)(Math.random() * 16.0)) {
            case 0: {
                return Items.f_42498_;
            }
            case 1: {
                return Items.f_42494_;
            }
            case 2: {
                return Items.f_42495_;
            }
            case 3: {
                return Items.f_42492_;
            }
            case 4: {
                return Items.f_42490_;
            }
            case 5: {
                return Items.f_42496_;
            }
            case 6: {
                return Items.f_42538_;
            }
            case 7: {
                return Items.f_42491_;
            }
            case 8: {
                return Items.f_42540_;
            }
            case 9: {
                return Items.f_42537_;
            }
            case 10: {
                return Items.f_42536_;
            }
            case 11: {
                return Items.f_42489_;
            }
            case 12: {
                return Items.f_42493_;
            }
            case 13: {
                return Items.f_42497_;
            }
            case 14: {
                return Items.f_42535_;
            }
            case 15: {
                return Items.f_42539_;
            }
        }
        return null;
    }

    public static boolean blockIsNearBlock(Level world, BlockPos pos, Block block) {
        for (Direction dir : Direction.values()) {
            if (world.m_8055_(pos.m_142300_(dir)).m_60734_() != block) continue;
            return true;
        }
        return false;
    }

    public static Field getField(Class<?> class1, String fieldName) {
        try {
            return class1.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException("could not get field " + fieldName + " from class " + class1.getName());
        }
    }

    public static <T> T getObjectFromField(Field field, Object obj) {
        try {
            return (T)field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("could not get object " + obj + " from field " + field.getName());
        }
    }

    @Nullable
    public static Item tryGetItem(String item) {
        try {
            return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Item getItem(Block block) {
        return Item.m_41439_((Block)block);
    }

    @Nullable
    public static Block tryGetBlock(String block) {
        try {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(block));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Block getBlock(String block) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(block));
    }

    public static ItemStack tryGetItemStack(String itemName) {
        Item item = Util.tryGetItem(itemName);
        if (item != null) {
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack parseStack(String str) {
        try {
            String[] parts = str.split(" ");
            int count = parts.length > 1 ? Integer.parseInt(parts[1]) : 1;
            ItemParser itemparser = new ItemParser(new StringReader(parts[0]), false).m_121032_();
            return new ItemInput(itemparser.m_121014_(), itemparser.m_121018_()).m_120980_(count, false);
        }
        catch (CommandSyntaxException e) {
            return ItemStack.f_41583_;
        }
    }

    public static float[] RGBtoHSB(int r, int g, int b) {
        float hue;
        int cmin;
        int cmax;
        float[] hsbvals = new float[3];
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static int[] HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new int[]{r, g, b};
    }

    public static boolean callBooleanMethod(Object obj, String methodName, Class<?> clazz, Object[] args, Class<?>[] paramTypes) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, paramTypes);
            method.setAccessible(true);
            Object ret = method.invoke(obj, args);
            if (ret instanceof Boolean) {
                return (Boolean)ret;
            }
            System.err.println("The return was not a boolean from method " + methodName + " from object " + obj.toString() + " of class " + obj.getClass().getName());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.err.println("Could not call boolean method " + methodName + " from object " + obj.toString() + " of class " + obj.getClass().getName());
            e.printStackTrace();
        }
        return false;
    }

    public static ItemStack stackListFind_ignoreNr(List<ItemStack> possibleInputs, ItemStack stack1) {
        for (ItemStack stack : possibleInputs) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)stack1)) continue;
            return stack;
        }
        return null;
    }

    public static ItemStack stackListFind_moreOrEqualNr(ItemStack stack1, List<ItemStack> possibleInputs) {
        for (ItemStack stack : possibleInputs) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)stack1) || stack1.m_41613_() < stack.m_41613_()) continue;
            return stack;
        }
        return null;
    }

    public static String substring(String s, int i) {
        if (i < 0) {
            return s.substring(s.length() + i, s.length());
        }
        return s.substring(i);
    }
}

