/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity;

import com.cerbon.bosses_of_mass_destruction.animation.PauseAnimationTimer;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.general.data.WeakHashPredicate;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.RandomUtils;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.VecUtils;
import com.cerbon.bosses_of_mass_destruction.client.render.BillboardRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.CompositeRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.ConditionalRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.FrameLimiter;
import com.cerbon.bosses_of_mass_destruction.client.render.FullRenderLight;
import com.cerbon.bosses_of_mass_destruction.client.render.LerpedPosRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.PetalBladeParticleRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.PetalBladeRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.SimpleEntityRenderer;
import com.cerbon.bosses_of_mass_destruction.config.BMDConfig;
import com.cerbon.bosses_of_mass_destruction.entity.GeoModel;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletCodeAnimations;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletEnergyRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletLaserRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletOverlay;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletTextureProvider;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.LaserParticleRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.BoundedLighting;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.EternalNightRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichBoneLight;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichCodeAnimations;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichKillCounter;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithArmorRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithBoneLight;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.NoRedOnDeathOverlay;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.SporeBallOverlay;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.SporeBallSizeRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.SporeCodeAnimations;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomBoneLight;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomCodeAnimations;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomSpikeRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.util.SimpleGeoRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.util.SimpleLivingGeoRenderer;
import com.cerbon.bosses_of_mass_destruction.item.custom.ChargedEnderPearlEntity;
import com.cerbon.bosses_of_mass_destruction.item.custom.SoulStarEntity;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.particle.ClientParticleBuilder;
import com.cerbon.bosses_of_mass_destruction.particle.ParticleFactories;
import com.cerbon.bosses_of_mass_destruction.projectile.MagicMissileProjectile;
import com.cerbon.bosses_of_mass_destruction.projectile.PetalBladeProjectile;
import com.cerbon.bosses_of_mass_destruction.projectile.SporeBallProjectile;
import com.cerbon.bosses_of_mass_destruction.projectile.comet.CometCodeAnimations;
import com.cerbon.bosses_of_mass_destruction.projectile.comet.CometProjectile;
import com.cerbon.bosses_of_mass_destruction.util.BMDColors;
import com.mojang.blaze3d.Blaze3D;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import software.bernie.geckolib3.model.AnimatedGeoModel;

public class BMDEntities {
    public static final BMDConfig mobConfig = (BMDConfig)AutoConfig.getConfigHolder(BMDConfig.class).getConfig();
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"bosses_of_mass_destruction");
    public static final RegistryObject<EntityType<LichEntity>> LICH = ENTITY_TYPES.register("lich", () -> EntityType.Builder.m_20704_((entityType, level) -> new LichEntity((EntityType<? extends LichEntity>)entityType, level, BMDEntities.mobConfig.lichConfig), (MobCategory)MobCategory.MONSTER).m_20699_(1.8f, 3.0f).m_20717_(1).m_20712_(new ResourceLocation("bosses_of_mass_destruction", "lich").toString()));
    public static final RegistryObject<EntityType<MagicMissileProjectile>> MAGIC_MISSILE = ENTITY_TYPES.register("blue_fireball", () -> EntityType.Builder.m_20704_(MagicMissileProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_(new ResourceLocation("bosses_of_mass_destruction", "blue_fireball").toString()));
    public static final RegistryObject<EntityType<CometProjectile>> COMET = ENTITY_TYPES.register("comet", () -> EntityType.Builder.m_20704_(CometProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_(new ResourceLocation("bosses_of_mass_destruction", "comet").toString()));
    public static final RegistryObject<EntityType<SoulStarEntity>> SOUL_STAR = ENTITY_TYPES.register("soul_star", () -> EntityType.Builder.m_20704_(SoulStarEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_(new ResourceLocation("bosses_of_mass_destruction", "soul_star").toString()));
    public static final RegistryObject<EntityType<ChargedEnderPearlEntity>> CHARGED_ENDER_PEARL = ENTITY_TYPES.register("charged_ender_pearl", () -> EntityType.Builder.m_20704_(ChargedEnderPearlEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_(new ResourceLocation("bosses_of_mass_destruction", "charged_ender_pearl").toString()));
    public static final RegistryObject<EntityType<ObsidilithEntity>> OBSIDILITH = ENTITY_TYPES.register("obsidilith", () -> EntityType.Builder.m_20704_((entityType, level) -> new ObsidilithEntity((EntityType<? extends PathfinderMob>)entityType, level, BMDEntities.mobConfig.obsidilithConfig), (MobCategory)MobCategory.MONSTER).m_20699_(2.0f, 4.4f).m_20719_().m_20712_(new ResourceLocation("bosses_of_mass_destruction", "obsidilith").toString()));
    public static final RegistryObject<EntityType<GauntletEntity>> GAUNTLET = ENTITY_TYPES.register("gauntlet", () -> EntityType.Builder.m_20704_((entityType, level) -> new GauntletEntity((EntityType<? extends PathfinderMob>)entityType, level, BMDEntities.mobConfig.gauntletConfig), (MobCategory)MobCategory.MONSTER).m_20699_(5.0f, 4.0f).m_20719_().m_20712_(new ResourceLocation("bosses_of_mass_destruction", "gauntlet").toString()));
    public static final RegistryObject<EntityType<VoidBlossomEntity>> VOID_BLOSSOM = ENTITY_TYPES.register("void_blossom", () -> EntityType.Builder.m_20704_((entityType, level) -> new VoidBlossomEntity((EntityType<? extends PathfinderMob>)entityType, level, BMDEntities.mobConfig.voidBlossomConfig), (MobCategory)MobCategory.MONSTER).m_20699_(8.0f, 10.0f).m_20719_().setTrackingRange(3).m_20712_(new ResourceLocation("bosses_of_mass_destruction", "void_blossom").toString()));
    public static final RegistryObject<EntityType<SporeBallProjectile>> SPORE_BALL = ENTITY_TYPES.register("spore_ball", () -> EntityType.Builder.m_20704_(SporeBallProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_(new ResourceLocation("bosses_of_mass_destruction", "spore_ball").toString()));
    public static final RegistryObject<EntityType<PetalBladeProjectile>> PETAL_BLADE = ENTITY_TYPES.register("petal_blade", () -> EntityType.Builder.m_20704_(PetalBladeProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_(new ResourceLocation("bosses_of_mass_destruction", "petal_blade").toString()));
    public static final LichKillCounter killCounter = new LichKillCounter(BMDEntities.mobConfig.lichConfig.summonMechanic);

    public static void createAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)LICH.get(), Mob.m_21552_().m_22268_(Attributes.f_22280_, 5.0).m_22268_(Attributes.f_22276_, BMDEntities.mobConfig.lichConfig.health).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22281_, BMDEntities.mobConfig.lichConfig.missile.damage).m_22265_());
        event.put((EntityType)OBSIDILITH.get(), Mob.m_21552_().m_22268_(Attributes.f_22276_, BMDEntities.mobConfig.obsidilithConfig.health).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, BMDEntities.mobConfig.obsidilithConfig.attack).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22284_, BMDEntities.mobConfig.obsidilithConfig.armor).m_22265_());
        event.put((EntityType)GAUNTLET.get(), Mob.m_21552_().m_22268_(Attributes.f_22280_, 4.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22276_, BMDEntities.mobConfig.gauntletConfig.health).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22281_, BMDEntities.mobConfig.gauntletConfig.attack).m_22268_(Attributes.f_22284_, BMDEntities.mobConfig.gauntletConfig.armor).m_22265_());
        event.put((EntityType)VOID_BLOSSOM.get(), Mob.m_21552_().m_22268_(Attributes.f_22276_, BMDEntities.mobConfig.voidBlossomConfig.health).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, BMDEntities.mobConfig.voidBlossomConfig.attack).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22284_, BMDEntities.mobConfig.voidBlossomConfig.armor).m_22265_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        PauseAnimationTimer pauseSecondTimer = new PauseAnimationTimer(Blaze3D::m_83640_, () -> Minecraft.m_91087_().m_91104_());
        EntityRenderers.m_174036_((EntityType)((EntityType)LICH.get()), context -> {
            ResourceLocation texture = new ResourceLocation("bosses_of_mass_destruction", "textures/entity/lich.png");
            return new SimpleLivingGeoRenderer<LichEntity>(context, (AnimatedGeoModel<LichEntity>)new GeoModel<LichEntity>(lichEntity -> new ResourceLocation("bosses_of_mass_destruction", "geo/lich.geo.json"), entity -> texture, new ResourceLocation("bosses_of_mass_destruction", "animations/lich.animation.json"), new LichCodeAnimations()), new BoundedLighting(5), new LichBoneLight(), new EternalNightRenderer(), null, null, RenderType.m_110458_((ResourceLocation)texture), true);
        });
        EntityRenderers.m_174036_((EntityType)((EntityType)OBSIDILITH.get()), context -> {
            ObsidilithBoneLight runeColorHandler = new ObsidilithBoneLight();
            GeoModel<ObsidilithEntity> modelProvider = new GeoModel<ObsidilithEntity>(entity -> new ResourceLocation("bosses_of_mass_destruction", "geo/obsidilith.geo.json"), entity -> new ResourceLocation("bosses_of_mass_destruction", "textures/entity/obsidilith.png"), new ResourceLocation("bosses_of_mass_destruction", "animations/obsidilith.animation.json"), (animatable, data, geoModel) -> {});
            ObsidilithArmorRenderer armorRenderer = new ObsidilithArmorRenderer((AnimatedGeoModel<ObsidilithEntity>)modelProvider, context);
            return new SimpleLivingGeoRenderer<ObsidilithEntity>(context, (AnimatedGeoModel<ObsidilithEntity>)modelProvider, null, runeColorHandler, new CompositeRenderer(armorRenderer, runeColorHandler), armorRenderer, null, null, false);
        });
        EntityRenderers.m_174036_((EntityType)((EntityType)COMET.get()), context -> new SimpleGeoRenderer<CometProjectile>(context, (AnimatedGeoModel<CometProjectile>)new GeoModel<CometProjectile>(geoAnimatable -> new ResourceLocation("bosses_of_mass_destruction", "geo/comet.geo.json"), entity -> new ResourceLocation("bosses_of_mass_destruction", "textures/entity/comet.png"), new ResourceLocation("bosses_of_mass_destruction", "animations/comet.animation.json"), new CometCodeAnimations()), new ConditionalRenderer(new WeakHashPredicate(() -> new FrameLimiter(60.0f, pauseSecondTimer)::canDoFrame), new LerpedPosRenderer(vec3 -> ParticleFactories.cometTrail().build(vec3.m_82549_(RandomUtils.randVec().m_82490_(0.5)), Vec3.f_82478_))), null, new FullRenderLight(), null));
        EntityRenderers.m_174036_((EntityType)((EntityType)SOUL_STAR.get()), context -> new ThrownItemRenderer(context, 1.0f, true));
        EntityRenderers.m_174036_((EntityType)((EntityType)CHARGED_ENDER_PEARL.get()), ThrownItemRenderer::new);
        ResourceLocation missileTexture = new ResourceLocation("bosses_of_mass_destruction", "textures/entity/blue_magic_missile.png");
        RenderType magicMissileRenderType = RenderType.m_110458_((ResourceLocation)missileTexture);
        EntityRenderers.m_174036_((EntityType)((EntityType)MAGIC_MISSILE.get()), context -> new SimpleEntityRenderer<MagicMissileProjectile>(context, new CompositeRenderer(new BillboardRenderer<MagicMissileProjectile>(context.m_174022_(), magicMissileRenderType, f -> 0.5f), new ConditionalRenderer(new WeakHashPredicate(() -> new FrameLimiter(20.0f, pauseSecondTimer)::canDoFrame), new LerpedPosRenderer(vec3 -> ParticleFactories.soulFlame().build(vec3.m_82549_(RandomUtils.randVec().m_82490_(0.25)), Vec3.f_82478_)))), entity -> missileTexture, new FullRenderLight()));
        EntityRenderers.m_174036_((EntityType)((EntityType)GAUNTLET.get()), context -> {
            GeoModel<GauntletEntity> modelProvider = new GeoModel<GauntletEntity>(entity -> new ResourceLocation("bosses_of_mass_destruction", "geo/gauntlet.geo.json"), new GauntletTextureProvider(), new ResourceLocation("bosses_of_mass_destruction", "animations/gauntlet.animation.json"), new GauntletCodeAnimations());
            GauntletEnergyRenderer energyRenderer = new GauntletEnergyRenderer((AnimatedGeoModel<GauntletEntity>)modelProvider, context);
            GauntletOverlay overlayOverride = new GauntletOverlay();
            return new SimpleLivingGeoRenderer<GauntletEntity>(context, (AnimatedGeoModel<GauntletEntity>)modelProvider, null, null, new CompositeRenderer(new GauntletLaserRenderer(), new ConditionalRenderer<GauntletEntity>(new WeakHashPredicate(() -> new FrameLimiter(20.0f, pauseSecondTimer)::canDoFrame), new LaserParticleRenderer()), energyRenderer, overlayOverride), energyRenderer, overlayOverride, null, false);
        });
        EntityRenderers.m_174036_((EntityType)((EntityType)VOID_BLOSSOM.get()), context -> {
            ResourceLocation texture = new ResourceLocation("bosses_of_mass_destruction", "textures/entity/void_blossom.png");
            GeoModel<VoidBlossomEntity> modelProvider = new GeoModel<VoidBlossomEntity>(entity -> new ResourceLocation("bosses_of_mass_destruction", "geo/void_blossom.geo.json"), entity -> texture, new ResourceLocation("bosses_of_mass_destruction", "animations/void_blossom.animation.json"), new VoidBlossomCodeAnimations());
            VoidBlossomBoneLight boneLight = new VoidBlossomBoneLight();
            NoRedOnDeathOverlay overlay = new NoRedOnDeathOverlay();
            return new SimpleLivingGeoRenderer<VoidBlossomEntity>(context, (AnimatedGeoModel<VoidBlossomEntity>)modelProvider, null, boneLight, new CompositeRenderer(new VoidBlossomSpikeRenderer(), boneLight, overlay), null, overlay, null, false);
        });
        EntityRenderers.m_174036_((EntityType)((EntityType)SPORE_BALL.get()), context -> {
            SporeBallOverlay explosionFlasher = new SporeBallOverlay();
            return new SimpleGeoRenderer<SporeBallProjectile>(context, (AnimatedGeoModel<SporeBallProjectile>)new GeoModel<SporeBallProjectile>(geoAnimatable -> new ResourceLocation("bosses_of_mass_destruction", "geo/comet.geo.json"), entity -> new ResourceLocation("bosses_of_mass_destruction", "textures/entity/spore.png"), new ResourceLocation("bosses_of_mass_destruction", "animations/comet.animation.json"), new SporeCodeAnimations()), new CompositeRenderer(new ConditionalRenderer(new WeakHashPredicate(() -> new FrameLimiter(60.0f, pauseSecondTimer)::canDoFrame), new LerpedPosRenderer(vec3 -> {
                ClientParticleBuilder projectileParticles = new ClientParticleBuilder((ParticleOptions)BMDParticles.OBSIDILITH_BURST.get()).color(BMDColors.GREEN).colorVariation(0.4).scale(Float.valueOf(0.5f)).brightness(0xF000F0);
                projectileParticles.build(vec3.m_82549_(RandomUtils.randVec().m_82490_(0.25)), VecUtils.yAxis.m_82490_(0.1));
            })), explosionFlasher), new SporeBallSizeRenderer(), new FullRenderLight(), explosionFlasher);
        });
        ResourceLocation petalTexture = new ResourceLocation("bosses_of_mass_destruction", "textures/entity/petal_blade.png");
        RenderType petalBladeRenderType = RenderType.m_110458_((ResourceLocation)petalTexture);
        EntityRenderers.m_174036_((EntityType)((EntityType)PETAL_BLADE.get()), context -> new SimpleEntityRenderer<PetalBladeProjectile>(context, new CompositeRenderer(new PetalBladeRenderer(context.m_174022_(), petalBladeRenderType), new ConditionalRenderer(new WeakHashPredicate(() -> new FrameLimiter(30.0f, pauseSecondTimer)::canDoFrame), new PetalBladeParticleRenderer())), entity -> petalTexture, new FullRenderLight()));
    }

    public static void register(IEventBus eventBus) {
        ENTITY_TYPES.register(eventBus);
    }
}

