/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.api.maelstrom.general.random;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class WeightedRandom<E> {
    private final Random random;
    private final NavigableMap<Double, E> map;
    private double total;

    public WeightedRandom() {
        this(new Random());
    }

    public WeightedRandom(Random random) {
        this.random = random;
        this.map = new TreeMap<Double, E>();
        this.total = 0.0;
    }

    public WeightedRandom<E> add(double weight, E result) {
        if (weight <= 0.0) {
            return this;
        }
        if (Double.isNaN(weight) || Double.isInfinite(weight)) {
            throw new IllegalArgumentException("The weight for random collection is invalid: " + weight);
        }
        this.total += weight;
        this.map.put(this.total, result);
        return this;
    }

    public void addAll(Collection<Pair<Double, E>> collection) {
        for (Pair<Double, E> pair : collection) {
            this.add((Double)pair.getFirst(), pair.getSecond());
        }
    }

    public E next() {
        double value = this.random.nextDouble() * this.total;
        Map.Entry<Double, E> entry = this.map.higherEntry(value);
        return entry != null ? (E)entry.getValue() : null;
    }
}

