/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.engines.furnace;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xyz.przemyk.simpleplanes.client.ClientUtil;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.container.FuelSlot;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class FurnaceEngineUpgrade
extends EngineUpgrade {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler();
    public final LazyOptional<ItemStackHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);
    public int burnTime;
    public int burnTimeTotal;

    public FurnaceEngineUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)((Object)SimplePlanesUpgrades.FURNACE_ENGINE.get()), planeEntity);
    }

    @Override
    public void tick() {
        ItemStack itemStack;
        int itemBurnTime;
        if (this.burnTime > 0) {
            this.burnTime -= this.planeEntity.getFuelCost();
            this.updateClient();
        } else if (this.planeEntity.getThrottle() > 0 && (itemBurnTime = ForgeHooks.getBurnTime((ItemStack)(itemStack = this.itemStackHandler.getStackInSlot(0)), null)) > 0) {
            this.burnTimeTotal = itemBurnTime;
            this.burnTime = itemBurnTime;
            if (itemStack.hasContainerItem()) {
                this.itemStackHandler.setStackInSlot(0, itemStack.getContainerItem());
            } else {
                this.itemStackHandler.extractItem(0, 1, false);
            }
            this.updateClient();
        }
    }

    @Override
    public boolean isPowered() {
        return this.burnTime > 0;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("item", (Tag)this.itemStackHandler.serializeNBT());
        compound.m_128405_("burnTime", this.burnTime);
        compound.m_128405_("burnTimeTotal", this.burnTimeTotal);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.itemStackHandler.deserializeNBT(compound.m_128469_("item"));
        this.burnTime = compound.m_128451_("burnTime");
        this.burnTimeTotal = compound.m_128451_("burnTimeTotal");
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.itemStackHandler.getStackInSlot(0));
        buffer.m_130130_(this.burnTime);
        buffer.m_130130_(this.burnTimeTotal);
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        this.itemStackHandler.setStackInSlot(0, buffer.m_130267_());
        this.burnTime = buffer.m_130242_();
        this.burnTimeTotal = buffer.m_130242_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void onRemoved() {
        this.planeEntity.m_19998_((ItemLike)SimplePlanesItems.FURNACE_ENGINE.get());
        this.planeEntity.m_19983_(this.itemStackHandler.getStackInSlot(0));
    }

    @Override
    public void renderPowerHUD(PoseStack matrixStack, HumanoidArm side, int scaledWidth, int scaledHeight, float partialTicks) {
        ItemStack fuelStack;
        int i = scaledWidth / 2;
        Minecraft mc = Minecraft.m_91087_();
        if (side == HumanoidArm.LEFT) {
            ClientUtil.blit(matrixStack, -90, i - 91 - 29, scaledHeight - 40, 0, 44, 22, 40);
        } else {
            ClientUtil.blit(matrixStack, -90, i + 91, scaledHeight - 40, 0, 44, 22, 40);
        }
        if (this.burnTime > 0) {
            int burnTimeTotal2 = this.burnTimeTotal == 0 ? 200 : this.burnTimeTotal;
            int burnLeftScaled = this.burnTime * 13 / burnTimeTotal2;
            if (side == HumanoidArm.LEFT) {
                ClientUtil.blit(matrixStack, -90, i - 91 - 29 + 4, scaledHeight - 40 + 16 - burnLeftScaled, 22, 56 - burnLeftScaled, 14, burnLeftScaled + 1);
            } else {
                ClientUtil.blit(matrixStack, -90, i + 91 + 4, scaledHeight - 40 + 16 - burnLeftScaled, 22, 56 - burnLeftScaled, 14, burnLeftScaled + 1);
            }
        }
        if (!(fuelStack = this.itemStackHandler.getStackInSlot(0)).m_41619_()) {
            int i2 = scaledHeight - 16 - 3;
            if (side == HumanoidArm.LEFT) {
                ClientUtil.renderHotbarItem(matrixStack, i - 91 - 26, i2, partialTicks, fuelStack, mc);
            } else {
                ClientUtil.renderHotbarItem(matrixStack, i + 91 + 3, i2, partialTicks, fuelStack, mc);
            }
        }
    }

    @Override
    public void addContainerData(Function<Slot, Slot> addSlot, Function<DataSlot, DataSlot> addDataSlot) {
        addSlot.apply((Slot)new FuelSlot((IItemHandler)this.itemStackHandler, 0, 152, 62));
    }

    @Override
    public void renderScreenBg(PoseStack poseStack, int x, int y, float partialTicks, PlaneInventoryScreen screen) {
        screen.m_93228_(poseStack, screen.getGuiLeft() + 151, screen.getGuiTop() + 44, 208, 0, 18, 35);
        if (this.burnTime > 0) {
            int burnLeftScaled = this.burnTime * 13 / (this.burnTimeTotal == 0 ? 200 : this.burnTimeTotal);
            screen.m_93228_(poseStack, screen.getGuiLeft() + 152, screen.getGuiTop() + 57 - burnLeftScaled, 208, 47 - burnLeftScaled, 14, burnLeftScaled + 1);
        }
    }
}

