/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.container;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xyz.przemyk.simpleplanes.compat.ironchest.IronChestsCompat;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesContainers;

public class StorageContainer
extends AbstractContainerMenu {
    public final int rowCount;
    public final int size;
    public final String chestType;

    public StorageContainer(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, buffer.m_130136_(Short.MAX_VALUE));
    }

    private StorageContainer(int id, Inventory playerInventory, String chestType) {
        this(id, playerInventory, (IItemHandler)new ItemStackHandler(IronChestsCompat.getSize(chestType)), chestType);
    }

    public StorageContainer(int id, Inventory playerInventory, IItemHandler itemHandler, String chestType) {
        super((MenuType)SimplePlanesContainers.STORAGE.get(), id);
        this.rowCount = IronChestsCompat.getRowCount(chestType);
        IronChestsCompat.addSlots(chestType, itemHandler, this.rowCount, playerInventory, x$0 -> this.m_38897_((Slot)x$0));
        this.size = itemHandler.getSlots();
        this.chestType = chestType;
    }

    public boolean m_6875_(Player playerIn) {
        Entity entity = playerIn.m_20202_();
        if (entity instanceof LargePlaneEntity) {
            LargePlaneEntity largePlaneEntity = (LargePlaneEntity)entity;
            if (entity.m_6084_()) {
                return largePlaneEntity.hasStorageUpgrade();
            }
        }
        return false;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.size ? !this.m_38903_(itemstack1, this.size, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.size, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

