/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;

public class ClientUtil {
    public static void renderHotbarItem(PoseStack matrixStack, int x, int y, float partialTicks, ItemStack stack, Minecraft mc) {
        ItemRenderer itemRenderer = mc.m_91291_();
        if (!stack.m_41619_()) {
            float f = (float)stack.m_41779_() - partialTicks;
            if (f > 0.0f) {
                matrixStack.m_85836_();
                float f1 = 1.0f + f / 5.0f;
                matrixStack.m_85837_((double)(x + 8), (double)(y + 12), 0.0);
                matrixStack.m_85841_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                matrixStack.m_85837_((double)(-(x + 8)), (double)(-(y + 12)), 0.0);
            }
            itemRenderer.m_115203_(stack, x, y);
            if (f > 0.0f) {
                matrixStack.m_85849_();
            }
            itemRenderer.m_115169_(mc.f_91062_, stack, x, y);
        }
    }

    public static void blit(PoseStack matrixStack, int blitOffset, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        GuiComponent.m_93143_((PoseStack)matrixStack, (int)x, (int)y, (int)blitOffset, (float)uOffset, (float)vOffset, (int)uWidth, (int)vHeight, (int)256, (int)256);
    }

    public static void renderTiledTextureAtlas(PoseStack poseStack, AbstractContainerScreen<?> screen, TextureAtlasSprite sprite, int x, int y, int width, int height, int depth) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float u1 = sprite.m_118409_();
        float v1 = sprite.m_118411_();
        int spriteHeight = sprite.m_118408_();
        int spriteWidth = sprite.m_118405_();
        int startX = x + screen.getGuiLeft();
        int startY = y + screen.getGuiTop();
        do {
            int renderWidth;
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.m_118393_((double)(16.0f * (float)renderHeight / (float)spriteHeight));
            int x2 = startX;
            int widthLeft = width;
            Matrix4f matrix = poseStack.m_85850_().m_85861_();
            do {
                renderWidth = Math.min(spriteWidth, widthLeft);
                float u2 = sprite.m_118367_((double)(16.0f * (float)renderWidth / (float)spriteWidth));
                ClientUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v1, v2);
                x2 += renderWidth;
            } while ((widthLeft -= renderWidth) > 0);
            startY += renderHeight;
        } while (height > 0);
        Tesselator.m_85913_().m_85914_();
    }

    private static void buildSquare(Matrix4f matrix, BufferBuilder builder, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2) {
        builder.m_85982_(matrix, (float)x1, (float)y2, (float)z).m_7421_(u1, v2).m_5752_();
        builder.m_85982_(matrix, (float)x2, (float)y2, (float)z).m_7421_(u2, v2).m_5752_();
        builder.m_85982_(matrix, (float)x2, (float)y1, (float)z).m_7421_(u2, v1).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_5752_();
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    public static void setColorRGBA(int color) {
        float a = (float)ClientUtil.alpha(color) / 255.0f;
        float r = (float)ClientUtil.red(color) / 255.0f;
        float g = (float)ClientUtil.green(color) / 255.0f;
        float b = (float)ClientUtil.blue(color) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
    }

    public static void renderLiquidEngineFluid(PoseStack poseStack, PlaneInventoryScreen screen, FluidStack fluidStack, int height, int width, int fluidHeight) {
        TextureAtlasSprite fluidSprite = (TextureAtlasSprite)screen.getMinecraft().m_91258_(InventoryMenu.f_39692_).apply(fluidStack.getFluid().getAttributes().getStillTexture(fluidStack));
        ClientUtil.setColorRGBA(fluidStack.getFluid().getAttributes().getColor(fluidStack));
        ClientUtil.renderTiledTextureAtlas(poseStack, screen, fluidSprite, 153, 25 + height - 2 - fluidHeight, width - 4, fluidHeight, 100);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PlaneInventoryScreen.GUI);
    }
}

