/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import xyz.przemyk.simpleplanes.client.ClientUtil;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.client.gui.PlaneWorkbenchScreen;
import xyz.przemyk.simpleplanes.client.gui.RemoveUpgradesScreen;
import xyz.przemyk.simpleplanes.client.gui.StorageScreen;
import xyz.przemyk.simpleplanes.client.render.PlaneItemColors;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.network.ChangeThrottlePacket;
import xyz.przemyk.simpleplanes.network.DropPayloadPacket;
import xyz.przemyk.simpleplanes.network.MoveHeliUpPacket;
import xyz.przemyk.simpleplanes.network.OpenInventoryPacket;
import xyz.przemyk.simpleplanes.network.OpenPlaneInventoryPacket;
import xyz.przemyk.simpleplanes.network.PitchPacket;
import xyz.przemyk.simpleplanes.network.SimplePlanesNetworking;
import xyz.przemyk.simpleplanes.network.YawPacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesContainers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEventHandler {
    public static final ResourceLocation HUD_TEXTURE = new ResourceLocation("simpleplanes", "textures/gui/plane_hud.png");
    public static KeyMapping moveHeliUpKey;
    public static KeyMapping openPlaneInventoryKey;
    public static KeyMapping dropPayloadKey;
    public static KeyMapping throttleUp;
    public static KeyMapping throttleDown;
    public static KeyMapping pitchUp;
    public static KeyMapping pitchDown;
    public static KeyMapping yawRight;
    public static KeyMapping yawLeft;
    private static boolean oldMoveHeliUpState;
    private static boolean oldPitchUpState;
    private static boolean oldPitchDownState;
    private static boolean oldYawRightState;
    private static boolean oldYawLeftState;

    public static void clientSetup() {
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.PLANE_WORKBENCH.get()), PlaneWorkbenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.UPGRADES_REMOVAL.get()), RemoveUpgradesScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.STORAGE.get()), StorageScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.PLANE_INVENTORY.get()), PlaneInventoryScreen::new);
        moveHeliUpKey = new KeyMapping("key.move_heli_up.desc", 32, "key.simpleplanes.category");
        openPlaneInventoryKey = new KeyMapping("key.plane_inventory_open.desc", 88, "key.simpleplanes.category");
        dropPayloadKey = new KeyMapping("key.plane_drop_payload.desc", 67, "key.simpleplanes.category");
        throttleUp = new KeyMapping("key.plane_throttle_up.desc", 265, "key.simpleplanes.category");
        throttleDown = new KeyMapping("key.plane_throttle_down.desc", 264, "key.simpleplanes.category");
        pitchUp = new KeyMapping("key.plane_pitch_up.desc", 87, "key.simpleplanes.category");
        pitchDown = new KeyMapping("key.plane_pitch_down.desc", 83, "key.simpleplanes.category");
        yawRight = new KeyMapping("key.plane_yaw_right.desc", 262, "key.simpleplanes.category");
        yawLeft = new KeyMapping("key.plane_yaw_left.desc", 263, "key.simpleplanes.category");
        ClientRegistry.registerKeyBinding((KeyMapping)moveHeliUpKey);
        ClientRegistry.registerKeyBinding((KeyMapping)openPlaneInventoryKey);
        ClientRegistry.registerKeyBinding((KeyMapping)dropPayloadKey);
        ClientRegistry.registerKeyBinding((KeyMapping)throttleUp);
        ClientRegistry.registerKeyBinding((KeyMapping)throttleDown);
        ClientRegistry.registerKeyBinding((KeyMapping)pitchUp);
        ClientRegistry.registerKeyBinding((KeyMapping)pitchDown);
        ClientRegistry.registerKeyBinding((KeyMapping)yawRight);
        ClientRegistry.registerKeyBinding((KeyMapping)yawLeft);
        OverlayRegistry.registerOverlayTop((String)"plane_hud", (gui, matrixStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft mc = Minecraft.m_91087_();
            Gui patt5413$temp = mc.f_91065_;
            if (patt5413$temp instanceof ForgeIngameGui) {
                ForgeIngameGui forgeIngameGui = (ForgeIngameGui)patt5413$temp;
                int scaledWidth = mc.m_91268_().m_85445_();
                int scaledHeight = mc.m_91268_().m_85446_();
                Entity patt5643$temp = mc.f_91074_.m_20202_();
                if (patt5643$temp instanceof PlaneEntity) {
                    PlaneEntity planeEntity = (PlaneEntity)patt5643$temp;
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)HUD_TEXTURE);
                    int left_align = scaledWidth / 2 + 91;
                    int health = (int)Math.ceil(planeEntity.getHealth());
                    float healthMax = planeEntity.getMaxHealth();
                    int hearts = (int)healthMax;
                    if (hearts > 10) {
                        hearts = 10;
                    }
                    boolean FULL = false;
                    int EMPTY = 16;
                    int GOLD = 32;
                    int max_row_size = 5;
                    int heart = 0;
                    while (hearts > 0) {
                        int top = scaledHeight - forgeIngameGui.right_height;
                        int rowCount = Math.min(hearts, max_row_size);
                        hearts -= rowCount;
                        for (int i = 0; i < rowCount; ++i) {
                            int x = left_align - i * 16 - 16;
                            int vOffset = 35;
                            if (i + heart + 10 < health) {
                                ClientUtil.blit(matrixStack, 0, x, top, 32, vOffset, 16, 9);
                                continue;
                            }
                            if (i + heart < health) {
                                ClientUtil.blit(matrixStack, 0, x, top, 0, vOffset, 16, 9);
                                continue;
                            }
                            ClientUtil.blit(matrixStack, 0, x, top, 16, vOffset, 16, 9);
                        }
                        forgeIngameGui.right_height += 10;
                        heart += max_row_size;
                    }
                    ClientUtil.blit(matrixStack, -90, scaledWidth - 24, scaledHeight - 42, 0, 84, 22, 40);
                    int throttle = planeEntity.getThrottle();
                    if (throttle > 0) {
                        int throttleScaled = throttle * 28 / 10;
                        ClientUtil.blit(matrixStack, -90, scaledWidth - 24 + 10, scaledHeight - 42 + 6 + 28 - throttleScaled, 22, 118 - throttleScaled, 2, throttleScaled);
                    }
                    if (planeEntity.engineUpgrade != null) {
                        ItemStack offhandStack = mc.f_91074_.m_21206_();
                        HumanoidArm primaryHand = mc.f_91074_.m_5737_();
                        planeEntity.engineUpgrade.renderPowerHUD(matrixStack, primaryHand == HumanoidArm.LEFT || offhandStack.m_41619_() ? HumanoidArm.LEFT : HumanoidArm.RIGHT, scaledWidth, scaledHeight, partialTicks);
                    }
                }
            }
        });
    }

    public static void planeColor(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        SimplePlanesItems.getPlaneItems().forEach(item -> itemColors.m_92689_(PlaneItemColors::getColor, new ItemLike[]{item}));
    }

    public static void reloadTextures(TextureStitchEvent.Post event) {
        PlaneItemColors.clearCache();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPre(RenderLivingEvent.Pre<LivingEntity, ?> event) {
        LivingEntity livingEntity = event.getEntity();
        Entity entity = livingEntity.m_20201_();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            PoseStack matrixStack = event.getPoseStack();
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.375, 0.0);
            Quaternion quaternion = MathUtil.lerpQ(event.getPartialTick(), planeEntity.getQ_Prev(), planeEntity.getQ_Client());
            quaternion.m_80143_(quaternion.m_80140_(), -quaternion.m_80150_(), -quaternion.m_80153_(), quaternion.m_80156_());
            matrixStack.m_85845_(quaternion);
            float rotationYaw = MathUtil.lerpAngle(event.getPartialTick(), entity.f_19859_, entity.m_146908_());
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rotationYaw));
            matrixStack.m_85837_(0.0, -0.375, 0.0);
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                livingEntity.f_20885_ = planeEntity.m_146908_() * 2.0f - livingEntity.f_20885_;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                livingEntity.f_20886_ = planeEntity.f_19859_ * 2.0f - livingEntity.f_20886_;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPost(RenderLivingEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        Entity entity = livingEntity.m_20201_();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            event.getPoseStack().m_85849_();
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                livingEntity.f_20885_ = planeEntity.m_146908_() * 2.0f - event.getEntity().f_20885_;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                livingEntity.f_20886_ = planeEntity.f_19859_ * 2.0f - event.getEntity().f_20886_;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof LocalPlayer) {
            Entity entity = player.m_20202_();
            if (entity instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)entity;
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91066_.f_92111_ != CameraType.FIRST_PERSON) {
                    planeEntity.applyYawToEntity((Entity)player);
                }
                if (mc.f_91080_ == null && mc.m_91265_() == null && openPlaneInventoryKey.m_90859_()) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new OpenPlaneInventoryPacket());
                } else if (dropPayloadKey.m_90859_()) {
                    for (Upgrade upgrade : planeEntity.upgrades.values()) {
                        if (!upgrade.canBeDroppedAsPayload()) continue;
                        upgrade.dropAsPayload();
                        SimplePlanesNetworking.INSTANCE.sendToServer((Object)new DropPayloadPacket());
                        break;
                    }
                }
                if (throttleUp.m_90859_()) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new ChangeThrottlePacket(ChangeThrottlePacket.Type.UP));
                } else if (throttleDown.m_90859_()) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new ChangeThrottlePacket(ChangeThrottlePacket.Type.DOWN));
                }
                boolean isMoveHeliUp = moveHeliUpKey.m_90857_();
                boolean isPitchUp = pitchUp.m_90857_();
                boolean isPitchDown = pitchDown.m_90857_();
                boolean isYawRight = yawRight.m_90857_();
                boolean isYawLeft = yawLeft.m_90857_();
                if (isMoveHeliUp != oldMoveHeliUpState) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new MoveHeliUpPacket(isMoveHeliUp));
                }
                if (isPitchUp != oldPitchUpState || isPitchDown != oldPitchDownState) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new PitchPacket((byte)Boolean.compare(isPitchUp, isPitchDown)));
                }
                if (isYawRight != oldYawRightState || isYawLeft != oldYawLeftState) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new YawPacket((byte)Boolean.compare(isYawRight, isYawLeft)));
                }
                oldMoveHeliUpState = isMoveHeliUp;
                oldPitchUpState = isPitchUp;
                oldPitchDownState = isPitchDown;
                oldYawRightState = isYawRight;
                oldYawLeftState = isYawLeft;
            } else {
                oldMoveHeliUpState = false;
                oldPitchUpState = false;
                oldPitchDownState = false;
                oldYawRightState = false;
                oldYawLeftState = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        Camera camera = event.getCamera();
        Entity player = camera.m_90592_();
        Entity entity = player.m_20202_();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            if (camera.m_90594_()) {
                camera.m_90568_(-camera.m_90566_(4.0 * (planeEntity.getCameraDistanceMultiplayer() - 1.0)), 0.0, 0.0);
            } else {
                float heightDiff = 0.0f;
                if (planeEntity instanceof LargePlaneEntity) {
                    heightDiff = -0.1f;
                }
                double partialTicks = event.getPartialTicks();
                Quaternion qPrev = planeEntity.getQ_Prev();
                Quaternion qNow = planeEntity.getQ_Client();
                Vector3f eyePrev = new Vector3f(0.0f, 1.62f + heightDiff, 0.0f);
                Vector3f eyeNow = eyePrev.m_122281_();
                eyePrev.m_122251_(qPrev);
                eyeNow.m_122251_(qNow);
                camera.m_90581_(new Vec3(Mth.m_14139_((double)partialTicks, (double)(player.f_19854_ - (double)eyePrev.m_122239_()), (double)(player.m_20185_() - (double)eyeNow.m_122239_())), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)eyePrev.m_122260_()), (double)(player.m_20186_() + (double)eyeNow.m_122260_())) + 0.375, Mth.m_14139_((double)partialTicks, (double)(player.f_19856_ + (double)eyePrev.m_122269_()), (double)(player.m_20189_() + (double)eyeNow.m_122269_()))));
                qPrev.m_80148_(Vector3f.f_122225_.m_122240_(player.f_19859_));
                qPrev.m_80148_(Vector3f.f_122223_.m_122240_(event.getPitch()));
                MathUtil.EulerAngles eulerAnglesPrev = MathUtil.toEulerAngles(qPrev);
                qNow.m_80148_(Vector3f.f_122225_.m_122240_(player.m_146908_()));
                qNow.m_80148_(Vector3f.f_122223_.m_122240_(event.getPitch()));
                MathUtil.EulerAngles eulerAnglesNow = MathUtil.toEulerAngles(qNow);
                event.setPitch(-((float)MathUtil.lerpAngle(partialTicks, eulerAnglesPrev.pitch, eulerAnglesNow.pitch)));
                event.setYaw((float)MathUtil.lerpAngle(partialTicks, eulerAnglesPrev.yaw, eulerAnglesNow.yaw));
                event.setRoll(-((float)MathUtil.lerpAngle(partialTicks, eulerAnglesPrev.roll, eulerAnglesNow.roll)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void planeInventory(ScreenOpenEvent event) {
        LargePlaneEntity largePlaneEntity;
        Entity entity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.getScreen() instanceof InventoryScreen && (entity = player.m_20202_()) instanceof LargePlaneEntity && (largePlaneEntity = (LargePlaneEntity)entity).hasStorageUpgrade()) {
            event.setCanceled(true);
            SimplePlanesNetworking.INSTANCE.sendToServer((Object)new OpenInventoryPacket());
        }
    }

    static {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(ClientEventHandler::planeColor);
        eventBus.addListener(ClientEventHandler::reloadTextures);
        oldMoveHeliUpState = false;
        oldPitchUpState = false;
        oldPitchDownState = false;
        oldYawRightState = false;
        oldYawLeftState = false;
    }
}

