/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers.mixins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.smarterfarmers.MySortedMap;
import net.mehvahdjukaar.smarterfarmers.SmarterFarmers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.HarvestFarmland;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HarvestFarmland.class})
public abstract class FarmTaskMixin {
    @Shadow
    private BlockPos f_23159_;
    @Shadow
    private long f_23160_;
    @Final
    @Shadow
    private List<BlockPos> f_23162_;
    @Shadow
    private int f_23161_;

    @Shadow
    protected abstract BlockPos m_23164_(ServerLevel var1);

    private boolean canHarvest(BlockState state) {
        CropBlock crop;
        Block b = state.m_60734_();
        return b instanceof CropBlock && (crop = (CropBlock)b).m_52307_(state) || b instanceof SweetBerryBushBlock && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) == 2 || b instanceof IPlantable && state.m_61138_((Property)BlockStateProperties.f_61409_) && (Integer)state.m_61143_((Property)BlockStateProperties.f_61409_) == 7;
    }

    private boolean canBreak(BlockState state) {
        return state.m_204336_(SmarterFarmers.CROP_REPLACEABLE);
    }

    private boolean canPlantOn(BlockState state) {
        return state.m_60734_() instanceof FarmBlock || state.m_204336_(SmarterFarmers.CROP_PLANTABLE);
    }

    @Inject(method={"start(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/npc/Villager;J)V"}, at={@At(value="HEAD")})
    public void start(ServerLevel pLevel, Villager pEntity, long pGameTime, CallbackInfo ci) {
        if (pGameTime > this.f_23160_ && this.f_23159_ != null) {
            pEntity.m_8061_(EquipmentSlot.MAINHAND, this.getHoe(pEntity));
        }
    }

    @Inject(method={"stop(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/npc/Villager;J)V"}, at={@At(value="HEAD")})
    public void stop(ServerLevel pLevel, Villager pEntity, long pGameTime, CallbackInfo ci) {
        pEntity.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
    }

    protected ItemStack getHoe(Villager pEntity) {
        return switch (pEntity.m_7141_().m_35576_()) {
            default -> Items.f_42387_.m_7968_();
            case 1 -> Items.f_42424_.m_7968_();
            case 2 -> Items.f_42429_.m_7968_();
            case 4 -> Items.f_42434_.m_7968_();
            case 5 -> Items.f_42392_.m_7968_();
            case 6 -> Items.f_42397_.m_7968_();
        };
    }

    @Overwrite
    protected boolean m_23180_(BlockPos pPos, ServerLevel pLevel) {
        BlockState cropState = pLevel.m_8055_(pPos);
        BlockState farmState = pLevel.m_8055_(pPos.m_7495_());
        return (cropState.m_60795_() || this.canHarvest(cropState)) && this.canPlantOn(farmState) || this.canBreak(cropState) && (this.canPlantOn(farmState) || farmState.m_60713_(Blocks.f_50493_));
    }

    @Overwrite
    protected void m_6725_(ServerLevel world, Villager villager, long l) {
        if (this.f_23159_ == null || this.f_23159_.m_203195_((Position)villager.m_20182_(), 1.0)) {
            if (this.f_23159_ != null && l > this.f_23160_) {
                BlockState toHarvest = world.m_8055_(this.f_23159_);
                Block block = toHarvest.m_60734_();
                BlockPos belowPos = this.f_23159_.m_7495_();
                Item toReplace = Items.f_41852_;
                if (this.canBreak(toHarvest)) {
                    world.m_46953_(this.f_23159_, true, (Entity)villager);
                    BlockState below = world.m_8055_(belowPos);
                    if (below.m_60713_(Blocks.f_50493_)) {
                        world.m_7731_(belowPos, Blocks.f_50093_.m_49966_(), 11);
                        world.m_5594_(null, belowPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else if (this.canHarvest(toHarvest)) {
                    toReplace = block.m_5456_();
                    world.m_46953_(this.f_23159_, true, (Entity)villager);
                }
                BlockState farmlandBlock = world.m_8055_(belowPos);
                if (world.m_8055_(this.f_23159_).m_60795_() && this.canPlantOn(farmlandBlock)) {
                    SimpleContainer inventory = villager.m_141944_();
                    ItemStack itemStack = ItemStack.f_41583_;
                    boolean canPlant = false;
                    int ind = -1;
                    if (toReplace != Items.f_41852_ && toReplace instanceof BlockItem) {
                        for (int i = 0; i < inventory.m_6643_(); ++i) {
                            itemStack = inventory.m_8020_(i);
                            if (itemStack.m_41720_() != toReplace) continue;
                            canPlant = true;
                            ind = i;
                            break;
                        }
                    }
                    if (!canPlant) {
                        Optional opt;
                        MySortedMap<Block> map = new MySortedMap<Block>();
                        map.add(world.m_8055_(this.f_23159_.m_142127_()).m_60734_());
                        map.add(world.m_8055_(this.f_23159_.m_142128_()).m_60734_());
                        map.add(world.m_8055_(this.f_23159_.m_142126_()).m_60734_());
                        map.add(world.m_8055_(this.f_23159_.m_142125_()).m_60734_());
                        ArrayList surroundingBlocks = new ArrayList();
                        map.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(e -> surroundingBlocks.add((Block)e.getKey()));
                        HashMap<Block, Integer> availableSeeds = new HashMap<Block, Integer>();
                        for (int i = 0; i < inventory.m_6643_(); ++i) {
                            Block plantBlock;
                            itemStack = inventory.m_8020_(i);
                            Item it = itemStack.m_41720_();
                            if (!SmarterFarmers.isValidSeed(it) || ((IPlantable)(plantBlock = ((BlockItem)it).m_40614_())).getPlantType((BlockGetter)world, this.f_23159_) != PlantType.CROP) continue;
                            availableSeeds.put(plantBlock, i);
                        }
                        for (Block b : surroundingBlocks) {
                            if (!availableSeeds.containsKey(b)) continue;
                            ind = (Integer)availableSeeds.get(b);
                            canPlant = true;
                            itemStack = inventory.m_8020_(ind);
                            break;
                        }
                        if (!canPlant && (opt = availableSeeds.values().stream().findFirst()).isPresent()) {
                            ind = (Integer)opt.get();
                            canPlant = true;
                            itemStack = inventory.m_8020_(ind);
                        }
                    }
                    if (canPlant) {
                        world.m_7731_(this.f_23159_, ((IPlantable)((BlockItem)itemStack.m_41720_()).m_40614_()).getPlant((BlockGetter)world, this.f_23159_), 3);
                        world.m_6263_(null, (double)this.f_23159_.m_123341_(), (double)this.f_23159_.m_123342_(), (double)this.f_23159_.m_123343_(), SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        itemStack.m_41774_(1);
                        if (itemStack.m_41619_()) {
                            inventory.m_6836_(ind, ItemStack.f_41583_);
                        }
                    }
                }
                if (block instanceof CropBlock && !((CropBlock)block).m_52307_(toHarvest)) {
                    this.f_23162_.remove(this.f_23159_);
                    this.f_23159_ = this.m_23164_(world);
                    if (this.f_23159_ != null) {
                        this.f_23160_ = l + 20L;
                        villager.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.f_23159_), 0.5f, 1));
                        villager.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.f_23159_));
                    }
                }
            }
            ++this.f_23161_;
        }
    }
}

