/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import net.mehvahdjukaar.selene.villager_ai.VillagerBrainEvent;
import net.mehvahdjukaar.smarterfarmers.goal.EatFoodGoal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StemBlock;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="smarterfarmers")
public class SmarterFarmers {
    public static final String MOD_ID = "smarterfarmers";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final TagKey<Block> CROP_REPLACEABLE = BlockTags.create((ResourceLocation)new ResourceLocation("smarterfarmers", "crop_replaceable"));
    public static final TagKey<Block> CROP_PLANTABLE = BlockTags.create((ResourceLocation)new ResourceLocation("smarterfarmers", "crop_plantable"));
    public static final TagKey<Item> MEAT = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "food/meat"));

    public SmarterFarmers() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (ver, remote) -> true));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        try {
            HashMap<Item, Integer> newMap = new HashMap<Item, Integer>(Villager.f_35369_);
            for (Item i : ForgeRegistries.ITEMS) {
                if (!i.m_41472_() || i.m_41460_(new ItemStack((ItemLike)i)) != Rarity.COMMON || i.m_204114_().m_203656_(MEAT) || i instanceof BowlFoodItem || i instanceof HoneyBottleItem) continue;
                newMap.put(i, (int)Math.max(1.0f, (float)(i.m_41473_().m_38744_() * 2) / 3.0f));
            }
            Villager.f_35369_ = newMap;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add custom foods to villagers");
        }
    }

    public static boolean isValidSeed(Item item) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block b = blockItem.m_40614_();
            return b instanceof IPlantable && !(b instanceof StemBlock);
        }
        return false;
    }

    @SubscribeEvent
    public void onVillagerBrainInitialize(VillagerBrainEvent event) {
        if (!event.getVillager().m_6162_()) {
            event.addTaskToActivity(Activity.f_37983_, Pair.of((Object)7, (Object)((Object)new EatFoodGoal(100, 140))));
        }
    }
}

